/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.service.impl;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.model.AssetDisplayPageEntryTable;
import com.liferay.asset.display.page.service.base.AssetDisplayPageEntryLocalServiceBaseImpl;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.search.InfoSearchClassMapperTracker;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.display.page.model.AssetDisplayPageEntry"}, service={AopService.class})
public class AssetDisplayPageEntryLocalServiceImpl
extends AssetDisplayPageEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayPageEntryLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoSearchClassMapperTracker _infoSearchClassMapperTracker;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, int type, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long assetDisplayPageEntryId = this.counterLocalService.increment();
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryPersistence.create(assetDisplayPageEntryId);
        assetDisplayPageEntry.setUuid(serviceContext.getUuid());
        assetDisplayPageEntry.setGroupId(groupId);
        assetDisplayPageEntry.setCompanyId(user.getCompanyId());
        assetDisplayPageEntry.setUserId(user.getUserId());
        assetDisplayPageEntry.setUserName(user.getFullName());
        assetDisplayPageEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        assetDisplayPageEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        assetDisplayPageEntry.setClassNameId(classNameId);
        assetDisplayPageEntry.setClassPK(classPK);
        assetDisplayPageEntry.setLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
        assetDisplayPageEntry.setType(type);
        assetDisplayPageEntry.setPlid(this._getPlid(groupId, classNameId, classPK, layoutPageTemplateEntryId));
        assetDisplayPageEntry = (AssetDisplayPageEntry)this.assetDisplayPageEntryPersistence.update((BaseModel)assetDisplayPageEntry);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry != null) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return assetDisplayPageEntry;
    }

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws PortalException {
        return this.addAssetDisplayPageEntry(userId, groupId, classNameId, classPK, layoutPageTemplateEntryId, 1, serviceContext);
    }

    @SystemEvent(type=1)
    public void deleteAssetDisplayPageEntry(long groupId, long classNameId, long classPK) throws PortalException {
        this.assetDisplayPageEntryPersistence.removeByG_C_C(groupId, classNameId, classPK);
    }

    public AssetDisplayPageEntry fetchAssetDisplayPageEntry(long groupId, long classNameId, long classPK) {
        return this.assetDisplayPageEntryPersistence.fetchByG_C_C(groupId, classNameId, classPK);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntries(long classNameId, long classTypeId, long layoutPageTemplateEntryId, boolean defaultTemplate, int start, int end, OrderByComparator<AssetDisplayPageEntry> orderByComparator) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)AssetDisplayPageEntryTable.INSTANCE).from((Table)AssetDisplayPageEntryTable.INSTANCE).innerJoinON((Table)AssetEntryTable.INSTANCE, AssetDisplayPageEntryTable.INSTANCE.classPK.eq((Expression)AssetEntryTable.INSTANCE.classPK)).where(this._getPredicate(classNameId, classTypeId, layoutPageTemplateEntryId, defaultTemplate)).orderBy((Table)AssetDisplayPageEntryTable.INSTANCE, orderByComparator).limit(start, end);
        return (List)this.assetDisplayPageEntryPersistence.dslQuery(dslQuery);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryPersistence.findByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId, int start, int end, OrderByComparator<AssetDisplayPageEntry> orderByComparator) {
        return this.assetDisplayPageEntryPersistence.findByLayoutPageTemplateEntryId(layoutPageTemplateEntryId, start, end, orderByComparator);
    }

    public int getAssetDisplayPageEntriesCount(long classNameId, long classTypeId, long layoutPageTemplateEntryId, boolean defaultTemplate) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)AssetDisplayPageEntryTable.INSTANCE).innerJoinON((Table)AssetEntryTable.INSTANCE, AssetDisplayPageEntryTable.INSTANCE.classPK.eq((Expression)AssetEntryTable.INSTANCE.classPK)).where(this._getPredicate(classNameId, classTypeId, layoutPageTemplateEntryId, defaultTemplate));
        return this.assetDisplayPageEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public int getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryPersistence.countByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public AssetDisplayPageEntry updateAssetDisplayPageEntry(long assetDisplayPageEntryId, long layoutPageTemplateEntryId, int type) throws PortalException {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryPersistence.findByPrimaryKey(assetDisplayPageEntryId);
        assetDisplayPageEntry.setModifiedDate(new Date());
        assetDisplayPageEntry.setLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
        assetDisplayPageEntry.setType(type);
        long plid = this._getPlid(assetDisplayPageEntry.getGroupId(), assetDisplayPageEntry.getClassNameId(), assetDisplayPageEntry.getClassPK(), layoutPageTemplateEntryId);
        assetDisplayPageEntry.setPlid(plid);
        assetDisplayPageEntry = (AssetDisplayPageEntry)this.assetDisplayPageEntryPersistence.update((BaseModel)assetDisplayPageEntry);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry != null) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return assetDisplayPageEntry;
    }

    private long _getPlid(long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId) {
        String className = this._portal.getClassName(classNameId);
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderTracker.getLayoutDisplayPageProviderByClassName(className);
        if (layoutDisplayPageProvider == null) {
            return 0L;
        }
        LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(className, classPK));
        if (layoutDisplayPageObjectProvider == null) {
            return 0L;
        }
        long classTypeId = layoutDisplayPageObjectProvider.getClassTypeId();
        LayoutPageTemplateEntry layoutPageTemplateEntry = Optional.ofNullable(this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId)).orElseGet(() -> this._layoutPageTemplateEntryLocalService.fetchDefaultLayoutPageTemplateEntry(groupId, classNameId, classTypeId));
        if (layoutPageTemplateEntry != null) {
            return layoutPageTemplateEntry.getPlid();
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
        AssetEntry assetEntry = null;
        if (assetRendererFactory != null) {
            try {
                assetEntry = assetRendererFactory.getAssetEntry(this._portal.getClassName(classNameId), classPK);
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)portalException);
                }
            }
        } else {
            assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        }
        if (assetEntry == null) {
            return 0L;
        }
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(assetEntry.getLayoutUuid(), assetEntry.getGroupId(), false);
        if (layout != null) {
            return layout.getPlid();
        }
        layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(assetEntry.getLayoutUuid(), assetEntry.getGroupId(), true);
        if (layout != null) {
            return layout.getPlid();
        }
        return 0L;
    }

    private Predicate _getPredicate(long classNameId, long classTypeId, long layoutPageTemplateEntryId, boolean defaultTemplate) {
        return AssetDisplayPageEntryTable.INSTANCE.classNameId.eq((Object)classNameId).and(() -> {
            String searchClassName = this._infoSearchClassMapperTracker.getSearchClassName(this._portal.getClassName(classNameId));
            return AssetEntryTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(searchClassName));
        }).and((Expression)AssetDisplayPageEntryTable.INSTANCE.layoutPageTemplateEntryId.eq((Object)layoutPageTemplateEntryId).and((Expression)AssetDisplayPageEntryTable.INSTANCE.type.eq((Object)2)).withParentheses().or(() -> {
            if (defaultTemplate) {
                return AssetDisplayPageEntryTable.INSTANCE.type.eq((Object)1);
            }
            return null;
        }).withParentheses()).and(() -> {
            if (classTypeId > 0L) {
                return AssetEntryTable.INSTANCE.classTypeId.eq((Object)classTypeId);
            }
            return null;
        });
    }
}

