/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.upgrade.v2_1_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class AssetDisplayLayoutUpgradeProcess
extends UpgradeProcess {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    private final LayoutPageTemplateEntryService _layoutPageTemplateEntryService;

    public AssetDisplayLayoutUpgradeProcess(AssetEntryLocalService assetEntryLocalService, LayoutLocalService layoutLocalService, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, LayoutPageTemplateEntryService layoutPageTemplateEntryService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
        this._layoutPageTemplateEntryService = layoutPageTemplateEntryService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeAssetDisplayLayouts();
        this._upgradeSchema();
    }

    private long _getPlid(AssetEntry assetEntry, long userId, long groupId, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry == null) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(groupId, assetEntry.getClassNameId(), assetEntry.getClassTypeId());
        }
        if (layoutPageTemplateEntry == null) {
            return 0L;
        }
        if (layoutPageTemplateEntry.getPlid() > 0L) {
            return layoutPageTemplateEntry.getPlid();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this._layoutLocalService.addLayout(userId, groupId, false, 0L, assetEntry.getTitleMap(), assetEntry.getTitleMap(), assetEntry.getDescriptionMap(), null, null, "asset_display", "", true, true, new HashMap(), serviceContext);
        layoutPageTemplateEntry.setPlid(layout.getPlid());
        this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        return layout.getPlid();
    }

    private void _upgradeAssetDisplayLayouts() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"asset_display")));
        actionableDynamicQuery.setPerformActionMethod(layout -> {
            layout.setSystem(true);
            this._layoutLocalService.updateLayout(layout);
        });
        actionableDynamicQuery.performActions();
    }

    private void _upgradeSchema() throws Exception {
        this.alterTableAddColumn("AssetDisplayPageEntry", "plid", "LONG");
        ServiceContext serviceContext = new ServiceContext();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(StringBundler.concat((String[])new String[]{"select assetDisplayPageEntryId, userId, groupId, ", "classNameId, classPK, layoutPageTemplateEntryId from ", "AssetDisplayPageEntry where plid is null or plid = 0"}));
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update AssetDisplayPageEntry set plid = ? where assetDisplayPageEntryId = ?");){
            while (resultSet.next()) {
                long classPK;
                long classNameId = resultSet.getLong("classNameId");
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK = resultSet.getLong("classPK"));
                if (assetEntry == null) continue;
                long userId = resultSet.getLong("userId");
                long groupId = resultSet.getLong("groupId");
                long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                preparedStatement.setLong(1, this._getPlid(assetEntry, userId, groupId, layoutPageTemplateEntryId, serviceContext));
                long assetDisplayPageEntryId = resultSet.getLong("assetDisplayPageEntryId");
                preparedStatement.setLong(2, assetDisplayPageEntryId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

