/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.service.impl;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.base.AssetDisplayPageEntryServiceBaseImpl;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=asset", "json.web.service.context.path=AssetDisplayPageEntry"}, service={AopService.class})
public class AssetDisplayPageEntryServiceImpl
extends AssetDisplayPageEntryServiceBaseImpl {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Portal _portal;

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, int type, ServiceContext serviceContext) throws Exception {
        this._checkPermissions(this._portal.getClassName(classNameId), classPK, "UPDATE");
        return this.assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(userId, groupId, classNameId, classPK, layoutPageTemplateEntryId, type, serviceContext);
    }

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws Exception {
        this._checkPermissions(this._portal.getClassName(classNameId), classPK, "UPDATE");
        return this.assetDisplayPageEntryLocalService.addAssetDisplayPageEntry(userId, groupId, classNameId, classPK, layoutPageTemplateEntryId, serviceContext);
    }

    public void deleteAssetDisplayPageEntry(long groupId, long classNameId, long classPK) throws Exception {
        this._checkPermissions(this._portal.getClassName(classNameId), classPK, "DELETE");
        this.assetDisplayPageEntryLocalService.deleteAssetDisplayPageEntry(groupId, classNameId, classPK);
    }

    public AssetDisplayPageEntry fetchAssetDisplayPageEntry(long groupId, long classNameId, long classPK) throws Exception {
        this._checkPermissions(this._portal.getClassName(classNameId), classPK, "VIEW");
        return this.assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(groupId, classNameId, classPK);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntries(long classNameId, long classTypeId, long layoutPageTemplateEntryId, boolean defaultTemplate, int start, int end, OrderByComparator<AssetDisplayPageEntry> orderByComparator) {
        return this.assetDisplayPageEntryLocalService.getAssetDisplayPageEntries(classNameId, classTypeId, layoutPageTemplateEntryId, defaultTemplate, start, end, orderByComparator);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId, int start, int end, OrderByComparator<AssetDisplayPageEntry> orderByComparator) {
        return this.assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(layoutPageTemplateEntryId, start, end, orderByComparator);
    }

    public int getAssetDisplayPageEntriesCount(long classNameId, long classTypeId, long layoutPageTemplateEntryId, boolean defaultTemplate) {
        return this.assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesCount(classNameId, classTypeId, layoutPageTemplateEntryId, defaultTemplate);
    }

    public int getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public AssetDisplayPageEntry updateAssetDisplayPageEntry(long assetDisplayPageEntryId, long layoutPageTemplateEntryId, int type) throws Exception {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryPersistence.fetchByPrimaryKey(assetDisplayPageEntryId);
        this._checkPermissions(assetDisplayPageEntry.getClassName(), assetDisplayPageEntry.getClassPK(), "UPDATE");
        return this.assetDisplayPageEntryLocalService.updateAssetDisplayPageEntry(assetDisplayPageEntryId, layoutPageTemplateEntryId, type);
    }

    private void _checkPermissions(String className, long classPK, String actionId) throws Exception {
        AssetRendererFactory assetRendererFactory;
        InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemPermissionProvider.class, className);
        if (infoItemPermissionProvider != null ? !infoItemPermissionProvider.hasPermission(this.getPermissionChecker(), (Object)classPK, actionId) : !(assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className)).hasPermission(this.getPermissionChecker(), classPK, actionId)) {
            throw new PrincipalException();
        }
    }
}

