/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.internal.contributor.field;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.info.display.internal.asset.display.page.portlet.AssetDisplayPageFriendlyURLProviderUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.info.display.contributor.field.InfoDisplayContributorField;
import com.liferay.info.display.contributor.field.InfoDisplayContributorFieldType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.kernel.model.AssetEntry"}, service={InfoDisplayContributorField.class})
public class AssetEntryDisplayPageURLDisplayContributorField
implements InfoDisplayContributorField<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryDisplayPageURLDisplayContributorField.class);
    @Reference(target="(bundle.symbolic.name=com.liferay.asset.info.display.impl)")
    private ResourceBundleLoader _resourceBundleLoader;

    public String getKey() {
        return "displayPageURL";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"display-page-url");
    }

    public InfoDisplayContributorFieldType getType() {
        return InfoDisplayContributorFieldType.TEXT;
    }

    public String getValue(AssetEntry assetEntry, Locale locale) {
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer == null) {
            return "";
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext.getThemeDisplay() == null) {
            return "";
        }
        AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider = AssetDisplayPageFriendlyURLProviderUtil.getAssetDisplayPageFriendlyURLProvider();
        if (assetDisplayPageFriendlyURLProvider == null) {
            return "";
        }
        try {
            return assetDisplayPageFriendlyURLProvider.getFriendlyURL(assetEntry.getClassName(), assetEntry.getClassPK(), serviceContext.getThemeDisplay());
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to get view in context URL", (Throwable)portalException);
            return "";
        }
    }
}

