/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.internal.url.provider;

import com.liferay.asset.info.display.url.provider.AssetInfoEditURLProvider;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AssetInfoEditURLProvider.class})
public class AssetInfoEditURLProviderImpl
implements AssetInfoEditURLProvider {
    private static final Log _log = LogFactoryUtil.getLog(AssetInfoEditURLProviderImpl.class);
    @Reference
    private Portal _portal;

    public String getURL(String className, long classPK, HttpServletRequest httpServletRequest) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return "";
        }
        try {
            PortletURL editAssetEntryURL;
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            if (assetRenderer == null) {
                return "";
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())) {
                return "";
            }
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            if (Validator.isNull((String)redirect)) {
                Layout layout = themeDisplay.getLayout();
                if (layout.isTypeAssetDisplay()) {
                    redirect = themeDisplay.getURLCurrent();
                } else {
                    String mode = ParamUtil.getString((HttpServletRequest)this._portal.getOriginalServletRequest(httpServletRequest), (String)"p_l_mode", (String)"view");
                    redirect = HttpComponentsUtil.setParameter((String)this._portal.getLayoutRelativeURL(layout, themeDisplay), (String)"p_l_mode", (String)mode);
                }
            }
            if ((editAssetEntryURL = assetRenderer.getURLEdit(httpServletRequest, LiferayWindowState.NORMAL, redirect)) == null) {
                return "";
            }
            editAssetEntryURL.setParameter("portletResource", assetRendererFactory.getPortletId());
            return editAssetEntryURL.toString();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }
}

