/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.internal.item.provider;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.info.internal.item.AssetEntryInfoItemFields;
import com.liferay.asset.info.item.provider.AssetEntryInfoItemFieldSetProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.type.WebImage;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.template.info.item.provider.TemplateInfoItemFieldSetProvider;
import java.text.Format;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InfoItemFieldValuesProvider.class})
public class AssetEntryInfoItemFieldValuesProvider
implements InfoItemFieldValuesProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryInfoItemFieldValuesProvider.class);
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private AssetEntryInfoItemFieldSetProvider _assetEntryInfoItemFieldSetProvider;
    @Reference
    private Portal _portal;
    @Reference
    private TemplateInfoItemFieldSetProvider _templateInfoItemFieldSetProvider;
    @Reference
    private UserLocalService _userLocalService;

    public InfoItemFieldValues getInfoItemFieldValues(AssetEntry assetEntry) {
        return InfoItemFieldValues.builder().infoFieldValues(this._assetEntryInfoItemFieldSetProvider.getInfoFieldValues(assetEntry)).infoFieldValues(this._getAssetEntryInfoFieldValues(assetEntry)).infoFieldValues(this._templateInfoItemFieldSetProvider.getInfoFieldValues(AssetEntry.class.getName(), (Object)assetEntry)).infoItemReference(new InfoItemReference(AssetEntry.class.getName(), assetEntry.getEntryId())).build();
    }

    private List<InfoFieldValue<Object>> _getAssetEntryInfoFieldValues(AssetEntry assetEntry) {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        InfoFieldValue[] infoFieldValueArray = new InfoFieldValue[11];
        infoFieldValueArray[0] = new InfoFieldValue(AssetEntryInfoItemFields.titleInfoField, (Object)assetEntry.getTitle(locale));
        infoFieldValueArray[1] = new InfoFieldValue(AssetEntryInfoItemFields.descriptionInfoField, (Object)assetEntry.getDescription(locale));
        infoFieldValueArray[2] = new InfoFieldValue(AssetEntryInfoItemFields.summaryInfoField, (Object)assetEntry.getSummary(locale));
        infoFieldValueArray[3] = new InfoFieldValue(AssetEntryInfoItemFields.userNameInfoField, (Object)assetEntry.getUserName());
        infoFieldValueArray[4] = new InfoFieldValue(AssetEntryInfoItemFields.createDateInfoField, (Object)this._getDateValue(assetEntry.getCreateDate()));
        infoFieldValueArray[5] = new InfoFieldValue(AssetEntryInfoItemFields.modifiedDateInfoField, (Object)this._getDateValue(assetEntry.getModifiedDate()));
        infoFieldValueArray[6] = new InfoFieldValue(AssetEntryInfoItemFields.expirationDateInfoField, (Object)this._getDateValue(assetEntry.getExpirationDate()));
        infoFieldValueArray[7] = new InfoFieldValue(AssetEntryInfoItemFields.viewCountInfoField, () -> ((AssetEntry)assetEntry).getViewCount());
        infoFieldValueArray[8] = new InfoFieldValue(AssetEntryInfoItemFields.displayPageURLInfoField, (Object)this._getDisplayPageURL(assetEntry));
        infoFieldValueArray[9] = new InfoFieldValue(AssetEntryInfoItemFields.urlInfoField, (Object)assetEntry.getUrl());
        infoFieldValueArray[10] = new InfoFieldValue(AssetEntryInfoItemFields.userProfileImageInfoField, this._getUserNameProfileImage(assetEntry.getUserId()));
        return Arrays.asList(infoFieldValueArray);
    }

    private String _getDateValue(Date date) {
        if (date == null) {
            return "";
        }
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)locale);
        return dateFormatDateTime.format(date);
    }

    private String _getDisplayPageURL(AssetEntry assetEntry) {
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        if (themeDisplay == null) {
            return null;
        }
        try {
            return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(this._portal.getClassName(assetEntry.getClassNameId()), assetEntry.getClassPK(), themeDisplay);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private ThemeDisplay _getThemeDisplay() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            return serviceContext.getThemeDisplay();
        }
        return null;
    }

    private Object _getUserNameProfileImage(long userId) {
        block4: {
            User user = this._userLocalService.fetchUser(userId);
            if (user == null) {
                return null;
            }
            ThemeDisplay themeDisplay = this._getThemeDisplay();
            if (themeDisplay != null) {
                try {
                    WebImage webImage = new WebImage(user.getPortraitURL(themeDisplay));
                    webImage.setAlt(user.getFullName());
                    return webImage;
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        return null;
    }
}

