/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.internal.item.provider;

import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"info.item.identifier=com.liferay.info.item.ClassPKInfoItemIdentifier", "service.ranking:Integer=100"}, service={InfoItemObjectProvider.class})
public class AssetEntryInfoItemObjectProvider
implements InfoItemObjectProvider<AssetEntry> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public AssetEntry getInfoItem(InfoItemIdentifier infoItemIdentifier) throws NoSuchInfoItemException {
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            throw new NoSuchInfoItemException("Unsupported info item identifier type " + infoItemIdentifier);
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
        try {
            return this._assetEntryLocalService.getEntry(classPKInfoItemIdentifier.getClassPK());
        }
        catch (NoSuchEntryException noSuchEntryException) {
            throw new NoSuchInfoItemException("Unable to get asset entry " + classPKInfoItemIdentifier.getClassPK(), (Throwable)noSuchEntryException);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

