/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.internal.item.provider;

import com.liferay.asset.info.item.provider.AssetEntryInfoItemFieldSetProvider;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.CategoriesInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TagsInfoFieldType;
import com.liferay.info.item.field.reader.InfoItemFieldReaderFieldSetProvider;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.categorization.Category;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SortedArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AssetEntryInfoItemFieldSetProvider.class})
public class AssetEntryInfoItemFieldSetProviderImpl
implements AssetEntryInfoItemFieldSetProvider {
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private final InfoField<CategoriesInfoFieldType> _categoriesInfoField = InfoField.builder().infoFieldType((InfoFieldType)CategoriesInfoFieldType.INSTANCE).name("categories").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"all-categories")).multivalued(true).build();
    @Reference
    private InfoItemFieldReaderFieldSetProvider _infoItemFieldReaderFieldSetProvider;
    @Reference
    private Portal _portal;
    private final InfoField<TagsInfoFieldType> _tagsInfoField = InfoField.builder().infoFieldType((InfoFieldType)TagsInfoFieldType.INSTANCE).name("tagNames").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"tags")).multivalued(true).build();

    public InfoFieldSet getInfoFieldSet(AssetEntry assetEntry) {
        return this._getInfoFieldSet(this._getNoninternalAssetVocabularies(assetEntry));
    }

    public InfoFieldSet getInfoFieldSet(String itemClassName) {
        return this._getInfoFieldSet(Collections.emptyList());
    }

    public InfoFieldSet getInfoFieldSet(String itemClassName, long itemClassTypeId, long scopeGroupId) {
        return this._getInfoFieldSet(this._getNoninternalAssetVocabularies(itemClassName, itemClassTypeId, scopeGroupId));
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(AssetEntry assetEntry) {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        Set<AssetVocabulary> assetVocabularies = this._getNoninternalAssetVocabularies(assetEntry);
        for (AssetVocabulary assetVocabulary : assetVocabularies) {
            infoFieldValues.add(new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)CategoriesInfoFieldType.INSTANCE).name(assetVocabulary.getName()).labelInfoLocalizedValue(InfoLocalizedValue.builder().values(assetVocabulary.getTitleMap()).build()).build(), () -> this._getCategories(this._filterByVocabularyId(assetEntry.getCategories(), assetVocabulary.getVocabularyId()))));
        }
        infoFieldValues.add(new InfoFieldValue(this._categoriesInfoField, () -> this._getCategories(this._filterByVisibilityType(assetEntry.getCategories()))));
        infoFieldValues.add(new InfoFieldValue(this._tagsInfoField, () -> this._getTags(assetEntry.getTags())));
        infoFieldValues.addAll(this._infoItemFieldReaderFieldSetProvider.getInfoFieldValues(AssetEntry.class.getName(), (Object)assetEntry));
        return infoFieldValues;
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(String itemClassName, long itemClassPK) throws NoSuchInfoItemException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)itemClassName);
        try {
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(itemClassName, itemClassPK);
            return this.getInfoFieldValues(assetEntry);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            throw new NoSuchInfoItemException(StringBundler.concat((Object[])new Object[]{"Unable to get asset entry with class name ", itemClassName, " and class PK ", itemClassPK}), (Throwable)noSuchEntryException);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private List<AssetCategory> _filterByVisibilityType(List<AssetCategory> assetCategories) {
        return ListUtil.filter(assetCategories, assetCategory -> {
            AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
            return assetVocabulary.getVisibilityType() != 1;
        });
    }

    private List<AssetCategory> _filterByVocabularyId(List<AssetCategory> assetCategories, long vocabularyId) {
        return ListUtil.filter(assetCategories, assetCategory -> assetCategory.getVocabularyId() == vocabularyId);
    }

    private Set<AssetVocabulary> _getAssetVocabularies(AssetEntry assetEntry) {
        HashSet<AssetVocabulary> assetVocabularies = new HashSet<AssetVocabulary>(this._getAssetVocabularies(assetEntry.getClassName(), assetEntry.getClassTypeId(), assetEntry.getGroupId()));
        for (AssetCategory assetCategory : assetEntry.getCategories()) {
            assetVocabularies.add(this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId()));
        }
        return assetVocabularies;
    }

    private List<AssetVocabulary> _getAssetVocabularies(String itemClassName, long itemClassTypeId, long scopeGroupId) {
        try {
            if (itemClassTypeId > 0L) {
                return this._assetVocabularyLocalService.getGroupsVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId), itemClassName, itemClassTypeId);
            }
            return this._assetVocabularyLocalService.getGroupsVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId), itemClassName);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private List<Category> _getCategories(List<AssetCategory> assetCategories) {
        SortedArrayList categories = new SortedArrayList(Comparator.comparing(Category::getKey));
        for (AssetCategory assetCategory : assetCategories) {
            categories.add(this._getCategory(assetCategory));
        }
        return categories;
    }

    private Category _getCategory(AssetCategory assetCategory) {
        return new Category(assetCategory.getName(), InfoLocalizedValue.function(arg_0 -> ((AssetCategory)assetCategory).getTitle(arg_0)));
    }

    private InfoFieldSet _getInfoFieldSet(Collection<AssetVocabulary> assetVocabularies) {
        return InfoFieldSet.builder().infoFieldSetEntry(this._categoriesInfoField).infoFieldSetEntry(consumer -> assetVocabularies.forEach(assetVocabulary -> consumer.accept((Object)InfoField.builder().infoFieldType((InfoFieldType)CategoriesInfoFieldType.INSTANCE).name(assetVocabulary.getName()).labelInfoLocalizedValue(InfoLocalizedValue.builder().values(assetVocabulary.getTitleMap()).build()).build()))).infoFieldSetEntry(this._tagsInfoField).infoFieldSetEntry((InfoFieldSetEntry)this._infoItemFieldReaderFieldSetProvider.getInfoFieldSet(AssetEntry.class.getName())).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"categorization")).name("categorization").build();
    }

    private Set<AssetVocabulary> _getNoninternalAssetVocabularies(AssetEntry assetEntry) {
        HashSet<AssetVocabulary> assetVocabularies = new HashSet<AssetVocabulary>(this._getNoninternalAssetVocabularies(assetEntry.getClassName(), assetEntry.getClassTypeId(), assetEntry.getGroupId()));
        for (AssetCategory assetCategory : assetEntry.getCategories()) {
            AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
            if (assetVocabulary.getVisibilityType() == 1) continue;
            assetVocabularies.add(assetVocabulary);
        }
        return assetVocabularies;
    }

    private List<AssetVocabulary> _getNoninternalAssetVocabularies(String itemClassName, long itemClassTypeId, long scopeGroupId) {
        try {
            if (itemClassTypeId > 0L) {
                List groupsAssetVocabularies = this._assetVocabularyLocalService.getGroupsVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId), itemClassName, itemClassTypeId);
                return ListUtil.filter((List)groupsAssetVocabularies, assetVocabulary -> assetVocabulary.getVisibilityType() != 1);
            }
            List groupsAssetVocabularies = this._assetVocabularyLocalService.getGroupsVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId), itemClassName);
            return ListUtil.filter((List)groupsAssetVocabularies, assetVocabulary -> assetVocabulary.getVisibilityType() != 1);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private List<String> _getTags(List<AssetTag> assetTags) {
        ArrayList<String> tags = new ArrayList<String>(assetTags.size());
        for (AssetTag assetTag : assetTags) {
            tags.add(assetTag.getName());
        }
        return tags;
    }
}

