/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

import {openModal, openSimpleInputModal} from 'frontend-js-web';

import openDeleteAssetEntryListModal from './openDeleteAssetEntryListModal';

const ACTIONS = {
	deleteAssetListEntry(itemData) {
		openDeleteAssetEntryListModal({
			onDelete: () => {
				this.send(itemData.deleteAssetListEntryURL);
			},
		});
	},

	permissionsAssetEntryList(itemData) {
		openModal({
			title: Liferay.Language.get('permissions'),
			url: itemData.permissionsAssetEntryListURL,
		});
	},

	renameAssetListEntry(itemData, portletNamespace) {
		openSimpleInputModal({
			dialogTitle: Liferay.Language.get('rename-collection'),
			formSubmitURL: itemData.renameAssetListEntryURL,
			idFieldName: 'id',
			idFieldValue: itemData.assetListEntryId,
			mainFieldLabel: Liferay.Language.get('title'),
			mainFieldName: 'title',
			mainFieldPlaceholder: Liferay.Language.get('title'),
			mainFieldValue: itemData.assetListEntryTitle,
			namespace: portletNamespace,
		});
	},

	send(url) {
		submitForm(document.hrefFm, url);
	},
};

export default function propsTransformer({items, portletNamespace, ...props}) {
	return {
		...props,
		items: items.map((item) => {
			return {
				...item,
				items: item.items.map((child) => ({
					...child,
					onClick(event) {
						const action = child.data?.action;

						if (action) {
							event.preventDefault();

							ACTIONS[action](child.data, portletNamespace);
						}
					},
				})),
			};
		}),
	};
}
