/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.change.tracking.spi.listener;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetTagPersistence;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.model.BaseModel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class AssetTagCTEventListener
implements CTEventListener {
    @Reference
    private AssetTagLocalService _assetTagLocalService;

    public void onAfterCopy(long sourceCTCollectionId, long targetCTCollectionId) {
        try (SafeClosable safeClosable = CTCollectionThreadLocal.setCTCollectionId((long)targetCTCollectionId);){
            this._recalculateAssetCount(targetCTCollectionId);
        }
    }

    public void onBeforePublish(long ctCollectionId) {
        this._recalculateAssetCount(ctCollectionId);
    }

    private void _recalculateAssetCount(long ctCollectionId) {
        this._assetTagLocalService.updateWithUnsafeFunction(assetTagCTPersistence -> {
            AssetTagPersistence assetTagPersistence = (AssetTagPersistence)assetTagCTPersistence;
            Session session = assetTagCTPersistence.getCurrentSession();
            session.apply(connection -> {
                String sql = StringBundler.concat((Object[])new Object[]{"select distinct tagId from ", "AssetEntries_AssetTags where ctCollectionId = ", ctCollectionId});
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        long tagId = resultSet.getLong(1);
                        AssetTag assetTag = assetTagPersistence.fetchByPrimaryKey(tagId);
                        if (assetTag == null) continue;
                        int assetCount = assetTagPersistence.getAssetEntriesSize(tagId);
                        if (assetTag.getAssetCount() == assetCount) continue;
                        assetTag.setAssetCount(assetCount);
                        assetTagPersistence.update((BaseModel)assetTag);
                    }
                }
            });
            session.flush();
            session.clear();
            return null;
        });
    }
}

