/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.list.provider;

import com.liferay.asset.internal.info.list.provider.BaseAssetsInfoListProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.provider.InfoListProviderContext;
import com.liferay.info.pagination.Pagination;
import com.liferay.info.sort.Sort;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoListProvider.class})
public class MostViewedAssetsInfoListProvider
extends BaseAssetsInfoListProvider
implements InfoListProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(MostViewedAssetsInfoListProvider.class);
    @Reference
    private AssetEntryService _assetEntryService;
    @Reference(target="(bundle.symbolic.name=com.liferay.asset.service)")
    private ResourceBundleLoader _resourceBundleLoader;

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext) {
        return this.getInfoList(infoListProviderContext, null, null);
    }

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext, Pagination pagination, Sort sort) {
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(infoListProviderContext, "viewCount", "DESC", pagination);
        try {
            return this._assetEntryService.getEntries(assetEntryQuery);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public int getInfoListCount(InfoListProviderContext infoListProviderContext) {
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(infoListProviderContext, "viewCount", "DESC", null);
        try {
            return this._assetEntryService.getEntriesCount(assetEntryQuery);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries count", (Throwable)exception);
            return 0;
        }
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"most-viewed-assets");
    }
}

