/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.list.provider;

import com.liferay.asset.internal.info.list.provider.BaseAssetsInfoListProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.provider.InfoListProviderContext;
import com.liferay.info.pagination.Pagination;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoListProvider.class})
public class RecentContentInfoListProvider
extends BaseAssetsInfoListProvider
implements InfoListProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(RecentContentInfoListProvider.class);
    @Reference
    private AssetHelper _assetHelper;
    @Reference(target="(bundle.symbolic.name=com.liferay.asset.service)")
    private ResourceBundleLoader _resourceBundleLoader;

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext) {
        return this.getInfoList(infoListProviderContext, null, null);
    }

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext, Pagination pagination, com.liferay.info.sort.Sort sort) {
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(infoListProviderContext, "modified", "DESC", pagination);
        try {
            Hits hits = this._assetHelper.search(this._getSearchContext(infoListProviderContext), assetEntryQuery, assetEntryQuery.getStart(), assetEntryQuery.getEnd());
            return this._assetHelper.getAssetEntries(hits);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public int getInfoListCount(InfoListProviderContext infoListProviderContext) {
        try {
            Long count = this._assetHelper.searchCount(this._getSearchContext(infoListProviderContext), this.getAssetEntryQuery(infoListProviderContext, "modified", "DESC", null));
            return count.intValue();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries count", (Throwable)exception);
            return 0;
        }
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"recent-content");
    }

    private SearchContext _getSearchContext(InfoListProviderContext infoListProviderContext) throws Exception {
        Company company = infoListProviderContext.getCompany();
        long groupId = company.getGroupId();
        Optional groupOptional = infoListProviderContext.getGroupOptional();
        if (groupOptional.isPresent()) {
            Group group = (Group)groupOptional.get();
            groupId = group.getGroupId();
        }
        User user = infoListProviderContext.getUser();
        Optional layoutOptional = infoListProviderContext.getLayoutOptional();
        SearchContext searchContext = SearchContextFactory.getInstance((long[])new long[0], (String[])new String[0], new HashMap(), (long)company.getCompanyId(), null, (Layout)layoutOptional.orElse(null), null, (long)groupId, null, (long)user.getUserId());
        searchContext.setSorts(new Sort[]{SortFactoryUtil.create((String)"modified", (int)6, (boolean)true), SortFactoryUtil.create((String)"createDate", (int)6, (boolean)true)});
        return searchContext;
    }
}

