/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.list.provider;

import com.liferay.asset.internal.info.list.provider.BaseAssetsInfoListProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.provider.InfoListProviderContext;
import com.liferay.info.pagination.Pagination;
import com.liferay.info.sort.Sort;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoListProvider.class})
public class RelatedAssetsInfoListProvider
extends BaseAssetsInfoListProvider
implements InfoListProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(RelatedAssetsInfoListProvider.class);
    @Reference
    private AssetEntryService _assetEntryService;

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext) {
        return this.getInfoList(infoListProviderContext, null, null);
    }

    public List<AssetEntry> getInfoList(InfoListProviderContext infoListProviderContext, Pagination pagination, Sort sort) {
        long assetEntryId = this._getLayoutAssetEntryId();
        if (assetEntryId == 0L) {
            return Collections.emptyList();
        }
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(infoListProviderContext, "modified", "DESC", pagination);
        assetEntryQuery.setLinkedAssetEntryId(assetEntryId);
        try {
            return this._assetEntryService.getEntries(assetEntryQuery);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public int getInfoListCount(InfoListProviderContext infoListProviderContext) {
        long assetEntryId = this._getLayoutAssetEntryId();
        if (assetEntryId == 0L) {
            return 0;
        }
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(infoListProviderContext, "modified", "DESC", null);
        assetEntryQuery.setLinkedAssetEntryId(assetEntryId);
        try {
            return this._assetEntryService.getEntriesCount(assetEntryQuery);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries count", (Throwable)exception);
            return 0;
        }
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"related-assets");
    }

    public boolean isAvailable(InfoListProviderContext infoListProviderContext) {
        Optional layoutOptional = infoListProviderContext.getLayoutOptional();
        if (layoutOptional.isPresent()) {
            Layout layout = (Layout)layoutOptional.get();
            return layout.isTypeAssetDisplay();
        }
        return false;
    }

    private long _getLayoutAssetEntryId() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        AssetEntry layoutAssetEntry = (AssetEntry)httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY");
        if (layoutAssetEntry != null) {
            return layoutAssetEntry.getEntryId();
        }
        return 0L;
    }
}

