/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.search;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.util.AssetRendererFactoryLookup;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.view.count.service.ViewCountEntryLocalService;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AssetEntryDocumentContributor
implements DocumentContributor<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryDocumentContributor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetRendererFactoryLookup _assetRendererFactoryLookup;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ViewCountEntryLocalService _viewCountEntryLocalService;

    public void contribute(Document document, BaseModel<AssetEntry> baseModel) {
        Date displayDate;
        AssetEntry assetEntry;
        String className;
        block12: {
            className = document.get("entryClassName");
            AssetRendererFactory assetRendererFactory = this._assetRendererFactoryLookup.getAssetRendererFactoryByClassName(className);
            if (assetRendererFactory == null || !assetRendererFactory.isSelectable()) {
                return;
            }
            assetEntry = null;
            displayDate = new Date();
            try {
                displayDate = document.getDate("displayDate");
            }
            catch (ParseException parseException) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)"Unable to parse data ", (Throwable)parseException);
            }
        }
        if (displayDate.getTime() > System.currentTimeMillis()) {
            String uuid = GetterUtil.getString((String)document.get("uuid"));
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            assetEntry = this._assetEntryLocalService.fetchEntry(groupId, uuid);
        } else {
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK);
        }
        if (assetEntry == null) {
            return;
        }
        if (!document.hasField("createDate")) {
            document.addDate("createDate", assetEntry.getCreateDate());
        }
        if (assetEntry.getExpirationDate() != null) {
            document.addDate("expirationDate", assetEntry.getExpirationDate());
        } else {
            document.addDate("expirationDate", new Date(Long.MAX_VALUE));
        }
        if (!document.hasField("modified")) {
            document.addDate("modified", assetEntry.getModifiedDate());
        }
        document.addNumber("priority", assetEntry.getPriority());
        if (assetEntry.getPublishDate() != null) {
            document.addDate("publishDate", assetEntry.getPublishDate());
        } else {
            document.addDate("publishDate", new Date(0L));
        }
        document.addLocalizedKeyword("localized_title", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getTitleMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()), true, true);
        document.addNumber("viewCount", this._viewCountEntryLocalService.getViewCount(assetEntry.getCompanyId(), this._classNameLocalService.getClassNameId(AssetEntry.class), assetEntry.getPrimaryKey()));
        document.addKeyword("visible", assetEntry.isVisible());
    }
}

