/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.collection.provider;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.asset.util.comparator.AssetRendererFactoryTypeNameComparator;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.ConfigurableInfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.MultiselectInfoFieldType;
import com.liferay.info.field.type.OptionInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.localized.bundle.ModelResourceLocalizedValue;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"item.class.name=com.liferay.asset.kernel.model.AssetEntry"}, service={RelatedInfoItemCollectionProvider.class})
public class AssetEntriesWithAssetCategoriesInTheSameAssetVocabulariesRelatedInfoItemCollectionProvider
implements ConfigurableInfoCollectionProvider<AssetEntry>,
RelatedInfoItemCollectionProvider<AssetEntry, AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntriesWithAssetCategoriesInTheSameAssetVocabulariesRelatedInfoItemCollectionProvider.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetHelper _assetHelper;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        if (!(relatedItem instanceof AssetEntry)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        AssetEntry assetEntry = (AssetEntry)relatedItem;
        List assetCategories = assetEntry.getCategories();
        if (ListUtil.isEmpty((List)assetCategories)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        AssetEntryQuery assetEntryQuery = this._getAssetEntryQuery(assetCategories, collectionQuery);
        try {
            SearchContext searchContext = this._getSearchContext(assetEntry);
            Hits hits = this._assetHelper.search(searchContext, assetEntryQuery, assetEntryQuery.getStart(), assetEntryQuery.getEnd());
            Long count = this._assetHelper.searchCount(searchContext, assetEntryQuery);
            return InfoPage.of((List)this._assetHelper.getAssetEntries(hits), (Pagination)collectionQuery.getPagination(), (int)count.intValue());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getCollectionItemClassName() {
        return AssetEntry.class.getName();
    }

    public InfoForm getConfigurationInfoForm() {
        return InfoForm.builder().infoFieldSetEntry((InfoFieldSetEntry)this._getItemTypesInfoField()).build();
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "items-with-categories-in-the-same-vocabularies");
    }

    public Class<?> getSourceItemClass() {
        return AssetEntry.class;
    }

    private long[] _getAssetCategories(List<AssetCategory> assetEntryAssetCategories) {
        ArrayList assetCategories = new ArrayList();
        HashSet<Long> assetVocabularies = new HashSet<Long>();
        for (AssetCategory assetCategory : assetEntryAssetCategories) {
            if (!assetVocabularies.contains(assetCategory.getVocabularyId())) {
                assetCategories.addAll(this._assetCategoryLocalService.getVocabularyCategories(assetCategory.getVocabularyId(), -1, -1, null));
            }
            assetVocabularies.add(assetCategory.getVocabularyId());
        }
        return ListUtil.toLongArray(assetCategories, AssetCategoryModel::getCategoryId);
    }

    private BooleanClause[] _getAssetEntryIdBooleanClause(AssetEntry assetEntry) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        BooleanFilter assetEntryIdBooleanFilter = new BooleanFilter();
        TermsFilter assetEntryIdTermsFilter = new TermsFilter("assetEntryId");
        assetEntryIdTermsFilter.addValue(String.valueOf(assetEntry.getEntryId()));
        assetEntryIdBooleanFilter.add((Filter)assetEntryIdTermsFilter, BooleanClauseOccur.MUST_NOT);
        booleanQueryImpl.setPreBooleanFilter(assetEntryIdBooleanFilter);
        return new BooleanClause[]{BooleanClauseFactoryUtil.create((Query)booleanQueryImpl, (String)BooleanClauseOccur.MUST.getName())};
    }

    private AssetEntryQuery _getAssetEntryQuery(List<AssetCategory> assetEntryAssetCategories, CollectionQuery collectionQuery) {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setAnyCategoryIds(this._getAssetCategories(assetEntryAssetCategories));
        assetEntryQuery.setClassNameIds(this._getClassNameIds(collectionQuery));
        assetEntryQuery.setEnablePermissions(true);
        Pagination pagination = collectionQuery.getPagination();
        if (pagination != null) {
            assetEntryQuery.setEnd(pagination.getEnd());
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        assetEntryQuery.setGroupIds(new long[]{serviceContext.getScopeGroupId()});
        assetEntryQuery.setOrderByCol1("modified");
        assetEntryQuery.setOrderByType1("DESC");
        if (pagination != null) {
            assetEntryQuery.setStart(pagination.getStart());
        }
        return assetEntryQuery;
    }

    private long[] _getClassNameIds(CollectionQuery collectionQuery) {
        Map configuration = collectionQuery.getConfiguration();
        if (MapUtil.isNotEmpty((Map)configuration) && ArrayUtil.isNotEmpty((Object[])((Object[])configuration.get("item_types")))) {
            String[] itemTypes;
            ArrayList<Long> classNameIds = new ArrayList<Long>();
            for (String itemType : itemTypes = (String[])configuration.get("item_types")) {
                if (!Validator.isNotNull((String)itemType)) continue;
                classNameIds.add(this._portal.getClassNameId(itemType));
            }
            if (ListUtil.isNotEmpty(classNameIds)) {
                return ArrayUtil.toArray((Long[])classNameIds.toArray(new Long[0]));
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return AssetRendererFactoryRegistryUtil.getIndexableClassNameIds((long)serviceContext.getCompanyId(), (boolean)true);
    }

    private InfoField _getItemTypesInfoField() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        List assetRendererFactories = ListUtil.filter((List)AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)serviceContext.getCompanyId(), (boolean)true), assetRendererFactory -> {
            if (!assetRendererFactory.isCategorizable()) {
                return false;
            }
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._portal.getClassName(assetRendererFactory.getClassNameId()));
            return indexer != null;
        });
        assetRendererFactories.sort(new AssetRendererFactoryTypeNameComparator(serviceContext.getLocale()));
        InfoField.FinalStep finalStep = InfoField.builder().infoFieldType((InfoFieldType)MultiselectInfoFieldType.INSTANCE).namespace("").name("item_types").attribute(MultiselectInfoFieldType.OPTIONS, (Object)TransformUtil.transform((Collection)assetRendererFactories, assetRendererFactory -> new OptionInfoFieldType((InfoLocalizedValue)new ModelResourceLocalizedValue(assetRendererFactory.getClassName()), assetRendererFactory.getClassName()))).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"item-type")).localizable(true);
        return finalStep.build();
    }

    private SearchContext _getSearchContext(AssetEntry assetEntry) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        SearchContext searchContext = SearchContextFactory.getInstance((long[])new long[0], (String[])new String[0], (Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"head", (Object)true).build(), (long)serviceContext.getCompanyId(), null, (Layout)themeDisplay.getLayout(), null, (long)serviceContext.getScopeGroupId(), null, (long)serviceContext.getUserId());
        searchContext.setBooleanClauses(this._getAssetEntryIdBooleanClause(assetEntry));
        return searchContext;
    }
}

