/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.collection.provider;

import com.liferay.asset.internal.info.collection.provider.BaseAssetsInfoCollectionProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RelatedInfoItemCollectionProvider.class})
public class RelatedAssetsRelatedInfoItemCollectionProvider
extends BaseAssetsInfoCollectionProvider
implements RelatedInfoItemCollectionProvider<AssetEntry, AssetEntry> {
    @Reference
    private AssetEntryService _assetEntryService;
    @Reference
    private Language _language;

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        if (!(relatedItem instanceof AssetEntry)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        AssetEntry assetEntry = (AssetEntry)relatedItem;
        try {
            AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(assetEntry.getCompanyId(), assetEntry.getGroupId(), collectionQuery.getPagination(), collectionQuery.getSort(), null);
            assetEntryQuery.setLinkedAssetEntryIds(new long[]{assetEntry.getEntryId()});
            return InfoPage.of((List)this._assetEntryService.getEntries(assetEntryQuery), (Pagination)collectionQuery.getPagination(), (int)this._assetEntryService.getEntriesCount(assetEntryQuery));
        }
        catch (PortalException portalException) {
            return (InfoPage)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "related-assets");
    }
}

