/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.collection.provider;

import com.liferay.asset.internal.info.collection.provider.BaseAssetsInfoCollectionProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.info.sort.Sort;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InfoCollectionProvider.class})
public class MostViewedAssetsInfoCollectionProvider
extends BaseAssetsInfoCollectionProvider
implements InfoCollectionProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(MostViewedAssetsInfoCollectionProvider.class);
    @Reference
    private AssetEntryService _assetEntryService;
    @Reference
    private Language _language;

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), collectionQuery.getPagination(), new Sort("viewCount", true), new Sort("title", true));
        try {
            return InfoPage.of((List)this._assetEntryService.getEntries(assetEntryQuery), (Pagination)collectionQuery.getPagination(), (int)this._assetEntryService.getEntriesCount(assetEntryQuery));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "most-viewed-assets");
    }
}

