/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.collection.provider;

import com.liferay.asset.internal.info.collection.provider.BaseAssetsInfoCollectionProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InfoCollectionProvider.class})
public class RecentContentInfoCollectionProvider
extends BaseAssetsInfoCollectionProvider
implements InfoCollectionProvider<AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(RecentContentInfoCollectionProvider.class);
    @Reference
    private AssetHelper _assetHelper;
    @Reference
    private Language _language;

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), collectionQuery.getPagination(), new com.liferay.info.sort.Sort("modified", true), null);
        try {
            SearchContext searchContext = this._getSearchContext();
            Hits hits = this._assetHelper.search(searchContext, assetEntryQuery, assetEntryQuery.getStart(), assetEntryQuery.getEnd());
            long count = this._assetHelper.searchCount(searchContext, assetEntryQuery);
            return InfoPage.of((List)this._assetHelper.getAssetEntries(hits), (Pagination)collectionQuery.getPagination(), (int)((int)count));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "recent-content");
    }

    private SearchContext _getSearchContext() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        SearchContext searchContext = SearchContextFactory.getInstance((long[])new long[0], (String[])new String[0], new HashMap(), (long)serviceContext.getCompanyId(), null, (Layout)themeDisplay.getLayout(), null, (long)serviceContext.getScopeGroupId(), null, (long)serviceContext.getUserId());
        searchContext.setSorts(new Sort[]{SortFactoryUtil.create((String)"modified", (int)6, (boolean)true), SortFactoryUtil.create((String)"createDate", (int)6, (boolean)true)});
        return searchContext;
    }
}

