/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.search;

import com.liferay.asset.kernel.configuration.provider.AssetCategoryConfigurationProviderUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AssetSearcher
extends BaseSearcher {
    private AssetEntryQuery _assetEntryQuery;

    public static Indexer<?> getInstance() {
        return new AssetSearcher();
    }

    public AssetSearcher() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getSearchClassNames() {
        long[] classNameIds = this._assetEntryQuery.getClassNameIds();
        String[] classNames = new String[classNameIds.length];
        for (int i = 0; i < classNames.length; ++i) {
            long classNameId = classNameIds[i];
            classNames[i] = PortalUtil.getClassName((long)classNameId);
        }
        return classNames;
    }

    public void setAssetEntryQuery(AssetEntryQuery assetEntryQuery) {
        this._assetEntryQuery = assetEntryQuery;
    }

    protected void addImpossibleTerm(BooleanFilter queryBooleanFilter, String field) throws Exception {
        queryBooleanFilter.addTerm(field, "-1", BooleanClauseOccur.MUST);
    }

    protected void addSearchAllKeywords(BooleanFilter queryBooleanFilter) throws Exception {
        String[] allKeywords = this._assetEntryQuery.getAllKeywords();
        if (allKeywords.length == 0) {
            return;
        }
        BooleanQueryImpl keywordsQuery = new BooleanQueryImpl();
        for (String keyword : allKeywords) {
            if (keyword.contains(" ")) {
                keyword = StringUtil.quote((String)keyword, (char)'\"');
            }
            StringQuery stringQuery = new StringQuery(keyword);
            keywordsQuery.add((Query)stringQuery, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)new QueryFilter((Query)keywordsQuery), BooleanClauseOccur.MUST);
    }

    protected void addSearchAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] allTagIdsArray = this._assetEntryQuery.getAllTagIdsArray();
        if (allTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] allTagIds : allTagIdsArray) {
            if (allTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])allTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyKeywords(BooleanFilter queryBooleanFilter) throws Exception {
        String[] anyKeywords = this._assetEntryQuery.getAnyKeywords();
        if (anyKeywords.length == 0) {
            return;
        }
        BooleanQueryImpl keywordsQuery = new BooleanQueryImpl();
        for (String keyword : anyKeywords) {
            if (keyword.contains(" ")) {
                keyword = StringUtil.quote((String)keyword, (char)'\"');
            }
            StringQuery stringQuery = new StringQuery(keyword);
            keywordsQuery.add((Query)stringQuery, BooleanClauseOccur.SHOULD);
        }
        queryBooleanFilter.add((Filter)new QueryFilter((Query)keywordsQuery), BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] anyTagIds = this._assetEntryQuery.getAnyTagIds();
        if (anyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
        tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])anyTagIds));
        queryBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAssetCategoryIds(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        String[] fieldNamesArray = new String[]{"assetCategoryIds"};
        if (searchContext.isIncludeInternalAssetCategories()) {
            fieldNamesArray = new String[]{"assetCategoryIds", "assetInternalCategoryIds"};
        }
        this._addSearchAllCategories(queryBooleanFilter, fieldNamesArray);
        this._addSearchAnyCategories(queryBooleanFilter, fieldNamesArray);
        this._addSearchNotAllCategories(queryBooleanFilter, fieldNamesArray);
        this._addSearchNotAnyCategories(queryBooleanFilter, fieldNamesArray);
    }

    protected void addSearchAssetTagNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllTags(queryBooleanFilter);
        this.addSearchAnyTags(queryBooleanFilter);
        this.addSearchNotAllTags(queryBooleanFilter);
        this.addSearchNotAnyTags(queryBooleanFilter);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return Collections.emptyMap();
        }
        Map queries = super.addSearchKeywords(searchQuery, searchContext);
        String field = Field.getLocalizedName((Locale)searchContext.getLocale(), (String)"localized_title");
        Query query = searchQuery.addTerm(field, keywords, true);
        queries.put(field, query);
        return queries;
    }

    protected void addSearchLayout(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        String layoutUuid = (String)((Object)searchContext.getAttribute("layoutUuid"));
        if (Validator.isNotNull((String)layoutUuid)) {
            queryBooleanFilter.addRequiredTerm("layoutUuid", layoutUuid);
        }
    }

    protected void addSearchNotAllKeywords(BooleanFilter queryBooleanFilter) throws Exception {
        String[] notAllKeywords = this._assetEntryQuery.getNotAllKeywords();
        if (notAllKeywords.length == 0) {
            return;
        }
        BooleanQueryImpl keywordsQuery = new BooleanQueryImpl();
        for (String keyword : notAllKeywords) {
            if (keyword.contains(" ")) {
                keyword = StringUtil.quote((String)keyword, (char)'\"');
            }
            StringQuery stringQuery = new StringQuery(keyword);
            keywordsQuery.add((Query)stringQuery, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)new QueryFilter((Query)keywordsQuery), BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] notAllTagIdsArray = this._assetEntryQuery.getNotAllTagIdsArray();
        if (notAllTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] notAllTagIds : notAllTagIdsArray) {
            if (notAllTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAllTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyKeywords(BooleanFilter queryBooleanFilter) throws Exception {
        String[] notAnyKeywords = this._assetEntryQuery.getNotAnyKeywords();
        if (notAnyKeywords.length == 0) {
            return;
        }
        BooleanQueryImpl keywordsQuery = new BooleanQueryImpl();
        for (String keyword : notAnyKeywords) {
            if (keyword.contains(" ")) {
                keyword = StringUtil.quote((String)keyword, (char)'\"');
            }
            StringQuery stringQuery = new StringQuery(keyword);
            keywordsQuery.add((Query)stringQuery, BooleanClauseOccur.SHOULD);
        }
        queryBooleanFilter.add((Filter)new QueryFilter((Query)keywordsQuery), BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAnyTagIds = this._assetEntryQuery.getNotAnyTagIds();
        if (notAnyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIgsTermsFilter = new TermsFilter("assetTagIds");
        tagIgsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAnyTagIds));
        queryBooleanFilter.add((Filter)tagIgsTermsFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllKeywords(fullQueryBooleanFilter);
        this.addSearchAnyKeywords(fullQueryBooleanFilter);
        this.addSearchNotAnyKeywords(fullQueryBooleanFilter);
        this.addSearchNotAllKeywords(fullQueryBooleanFilter);
        return super.createFullQuery(fullQueryBooleanFilter, searchContext);
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        boolean showInvisible = GetterUtil.getBoolean((Object)this._assetEntryQuery.getAttribute("showInvisible"));
        if (showInvisible) {
            return;
        }
        BooleanFilter booleanFilter = fullQuery.getPreBooleanFilter();
        if (booleanFilter == null) {
            booleanFilter = new BooleanFilter();
        }
        booleanFilter.addRequiredTerm("visible", true);
        if (booleanFilter.hasClauses() && !showInvisible) {
            fullQuery.setPreBooleanFilter(booleanFilter);
        }
    }

    private void _addSearchAllCategories(BooleanFilter queryBooleanFilter, String ... fieldNamesArray) throws Exception {
        for (String fieldName : fieldNamesArray) {
            long[] allCategoryIds = this._filterCategoryIdsByVisibilityType(this._assetEntryQuery.getAllCategoryIds(), fieldName);
            if (allCategoryIds.length == 0) continue;
            queryBooleanFilter.add((Filter)this._getCategoryIdsBooleanFilter(fieldName, allCategoryIds), BooleanClauseOccur.MUST);
        }
    }

    private void _addSearchAnyCategories(BooleanFilter queryBooleanFilter, String ... fieldNamesArray) throws Exception {
        BooleanFilter categoryIdsQueryBooleanFilter = new BooleanFilter();
        for (String fieldName : fieldNamesArray) {
            long[] anyCategoryIds = this._filterCategoryIdsByVisibilityType(this._assetEntryQuery.getAnyCategoryIds(), fieldName);
            if (anyCategoryIds.length == 0) continue;
            categoryIdsQueryBooleanFilter.add((Filter)this._getCategoryIdsTermsFilter(fieldName, anyCategoryIds), BooleanClauseOccur.SHOULD);
        }
        if (categoryIdsQueryBooleanFilter.hasClauses()) {
            queryBooleanFilter.add((Filter)categoryIdsQueryBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _addSearchNotAllCategories(BooleanFilter queryBooleanFilter, String ... fieldNamesArray) {
        BooleanFilter categoryIdsQueryBooleanFilter = new BooleanFilter();
        for (String fieldName : fieldNamesArray) {
            long[] filteredNotAllCategoryIds = this._filterCategoryIdsByVisibilityType(this._assetEntryQuery.getNotAllCategoryIds(), fieldName);
            if (filteredNotAllCategoryIds.length == 0) continue;
            categoryIdsQueryBooleanFilter.add((Filter)this._getCategoryIdsBooleanFilter(fieldName, filteredNotAllCategoryIds), BooleanClauseOccur.MUST);
        }
        if (categoryIdsQueryBooleanFilter.hasClauses()) {
            queryBooleanFilter.add((Filter)categoryIdsQueryBooleanFilter, BooleanClauseOccur.MUST_NOT);
        }
    }

    private void _addSearchNotAnyCategories(BooleanFilter queryBooleanFilter, String ... fieldNamesArray) {
        for (String fieldName : fieldNamesArray) {
            long[] filteredNotAnyCategoryIds = this._filterCategoryIdsByVisibilityType(this._assetEntryQuery.getNotAnyCategoryIds(), fieldName);
            if (filteredNotAnyCategoryIds.length == 0) continue;
            queryBooleanFilter.add((Filter)this._getCategoryIdsTermsFilter(fieldName, filteredNotAnyCategoryIds), BooleanClauseOccur.MUST_NOT);
        }
    }

    private long[] _filterCategoryIdsByVisibilityType(long[] assetCategoryIds, String fieldName) {
        ArrayList<Long> filteredCategoryIds = new ArrayList<Long>();
        for (long assetCategoryId : assetCategoryIds) {
            AssetVocabulary assetVocabulary;
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)assetCategoryId);
            if (assetCategory == null || (assetVocabulary = AssetVocabularyLocalServiceUtil.fetchAssetVocabulary((long)assetCategory.getVocabularyId())) == null || assetVocabulary.getVisibilityType() == 1 && Objects.equals(fieldName, "assetCategoryIds") || assetVocabulary.getVisibilityType() == 0 && Objects.equals(fieldName, "assetInternalCategoryIds")) continue;
            filteredCategoryIds.add(assetCategoryId);
        }
        return ArrayUtil.toArray((Long[])filteredCategoryIds.toArray(new Long[0]));
    }

    private BooleanFilter _getCategoryIdsBooleanFilter(String fieldName, long[] filteredCategoryIds) {
        BooleanFilter categoryIdsBooleanFilter = new BooleanFilter();
        for (long categoryId : filteredCategoryIds) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId())) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)categoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(categoryId);
            }
            TermsFilter categoryIdTermsFilter = new TermsFilter(fieldName);
            categoryIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
            categoryIdsBooleanFilter.add((Filter)categoryIdTermsFilter, BooleanClauseOccur.MUST);
        }
        return categoryIdsBooleanFilter;
    }

    private TermsFilter _getCategoryIdsTermsFilter(String fieldName, long[] filteredCategoryIds) {
        TermsFilter categoryIdsTermsFilter = new TermsFilter(fieldName);
        for (long categoryId : filteredCategoryIds) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId())) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)categoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(categoryId);
            }
            categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[0])));
        }
        return categoryIdsTermsFilter;
    }
}

