/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.test.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AssetTestUtil {
    public static AssetEntry addAssetEntry(long groupId) {
        return AssetTestUtil.addAssetEntry(groupId, null);
    }

    public static AssetEntry addAssetEntry(long groupId, Date publishDate) {
        return AssetTestUtil.addAssetEntry(groupId, publishDate, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
    }

    public static AssetEntry addAssetEntry(long groupId, Date publishDate, String className) {
        long assetEntryId = CounterLocalServiceUtil.increment();
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.createAssetEntry((long)assetEntryId);
        assetEntry.setClassName(className);
        assetEntry.setGroupId(groupId);
        assetEntry.setClassPK(RandomTestUtil.randomLong());
        assetEntry.setVisible(true);
        assetEntry.setPublishDate(publishDate);
        return AssetEntryLocalServiceUtil.updateAssetEntry((AssetEntry)assetEntry);
    }

    public static AssetCategory addCategory(long groupId, long vocabularyId) throws Exception {
        return AssetTestUtil.addCategory(groupId, vocabularyId, 0L);
    }

    public static AssetCategory addCategory(long groupId, long vocabularyId, long parentCategoryId) throws Exception {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap titleMap = HashMapBuilder.put((Object)locale, (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build();
        HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build();
        String[] categoryProperties = null;
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId, (long)TestPropsValues.getUserId());
        return AssetCategoryLocalServiceUtil.addCategory(null, (long)TestPropsValues.getUserId(), (long)groupId, (long)parentCategoryId, (Map)titleMap, (Map)descriptionMap, (long)vocabularyId, categoryProperties, (ServiceContext)serviceContext);
    }

    public static AssetTag addTag(long groupId) throws Exception {
        return AssetTestUtil.addTag(groupId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
    }

    public static AssetTag addTag(long groupId, String assetTagName) throws PortalException {
        long userId = TestPropsValues.getUserId();
        return AssetTagLocalServiceUtil.addTag((long)userId, (long)groupId, (String)assetTagName, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId));
    }

    public static AssetVocabulary addVocabulary(long groupId) throws Exception {
        long userId = TestPropsValues.getUserId();
        return AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (long)groupId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId));
    }

    public static AssetVocabulary addVocabulary(long groupId, long classNameId, long classTypePK, boolean required) throws Exception {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap titleMap = HashMapBuilder.put((Object)locale, (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build();
        HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).build();
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{classNameId}, new long[]{classTypePK}, new boolean[]{required});
        vocabularySettingsHelper.setMultiValued(true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId, (long)TestPropsValues.getUserId());
        return AssetVocabularyServiceUtil.addVocabulary((long)groupId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (Map)titleMap, (Map)descriptionMap, (String)vocabularySettingsHelper.toString(), (ServiceContext)serviceContext);
    }

    public static AssetVocabulary addVocabulary(long groupId, String name) throws Exception {
        long userId = TestPropsValues.getUserId();
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId);
        return AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (long)groupId, (String)name, (String)name, Collections.singletonMap(LocaleUtil.getDefault(), name), Collections.emptyMap(), (String)"", (ServiceContext)serviceContext);
    }
}

