/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.test.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.test.util.AssetEntryQueryTestUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.SearchContextTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.search.test.util.SearchTestRule;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.test.rule.LiferayIntegrationTestRule;
import com.liferay.portal.util.PropsValues;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public abstract class BaseAssetSearchTestCase {
    @ClassRule
    @Rule
    public static final AggregateTestRule aggregateTestRule = new LiferayIntegrationTestRule();
    @Rule
    public SearchTestRule searchTestRule = new SearchTestRule();
    private long[] _assetCategoryIds1;
    private long[] _assetCategoryIds2;
    @Inject
    private AssetHelper _assetHelper;
    private String[] _assetTagsNames1;
    private String[] _assetTagsNames2;
    private long _fashionCategoryId;
    private long _foodCategoryId;
    @DeleteAfterTestRun
    private Group _group1;
    @DeleteAfterTestRun
    private Group _group2;
    private long _healthCategoryId;
    private long _sportCategoryId;
    private long _travelCategoryId;
    private long _vocabularyId;

    @Before
    public void setUp() throws Exception {
        long[] groupIds;
        this._group1 = GroupTestUtil.addGroup();
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
        this._vocabularyId = vocabulary.getVocabularyId();
        AssetCategory fashionCategory = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)"Fashion", (long)this._vocabularyId, (ServiceContext)serviceContext);
        this._fashionCategoryId = fashionCategory.getCategoryId();
        AssetCategory foodCategory = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)"Food", (long)this._vocabularyId, (ServiceContext)serviceContext);
        this._foodCategoryId = foodCategory.getCategoryId();
        AssetCategory healthCategory = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)"Health", (long)this._vocabularyId, (ServiceContext)serviceContext);
        this._healthCategoryId = healthCategory.getCategoryId();
        AssetCategory sportCategory = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)"Sport", (long)this._vocabularyId, (ServiceContext)serviceContext);
        this._sportCategoryId = sportCategory.getCategoryId();
        AssetCategory travelCategory = AssetCategoryLocalServiceUtil.addCategory((long)TestPropsValues.getUserId(), (long)this._group1.getGroupId(), (String)"Travel", (long)this._vocabularyId, (ServiceContext)serviceContext);
        this._travelCategoryId = travelCategory.getCategoryId();
        this._assetCategoryIds1 = new long[]{this._healthCategoryId, this._sportCategoryId, this._travelCategoryId};
        this._assetCategoryIds2 = new long[]{this._fashionCategoryId, this._foodCategoryId, this._healthCategoryId, this._sportCategoryId};
        this._group2 = GroupTestUtil.addGroup();
        for (long groupId : groupIds = new long[]{this._group1.getGroupId(), this._group2.getGroupId()}) {
            serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
            AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)groupId, (String)"liferay", (ServiceContext)serviceContext);
            AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)groupId, (String)"architecture", (ServiceContext)serviceContext);
            AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)groupId, (String)"modularity", (ServiceContext)serviceContext);
            AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)groupId, (String)"osgi", (ServiceContext)serviceContext);
            AssetTagLocalServiceUtil.addTag((long)TestPropsValues.getUserId(), (long)groupId, (String)"services", (ServiceContext)serviceContext);
        }
        this._assetTagsNames1 = new String[]{"liferay", "architecture", "modularity", "osgi"};
        this._assetTagsNames2 = new String[]{"liferay", "architecture", "services"};
    }

    @Test
    public void testAllAssetCategories1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new long[]{this._healthCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAllAssetCategories2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new long[]{this._healthCategoryId, this._sportCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAllAssetCategories3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._foodCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAllAssetCategories4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._foodCategoryId, this._travelCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testAllAssetTags1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new String[]{"liferay"}, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAllAssetTags2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture"}, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAllAssetTags3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture", "services"}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAllAssetTags4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture", "services", "osgi"}, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testAllAssetTagsMultipleGroups1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), null, null, new String[]{"liferay"}, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 4);
    }

    @Test
    public void testAllAssetTagsMultipleGroups2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture"}, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 4);
    }

    @Test
    public void testAllAssetTagsMultipleGroups3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture", "services"}, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 2);
    }

    @Test
    public void testAllAssetTagsMultipleGroups4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture", "services", "osgi"}, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 0);
    }

    @Test
    public void testAnyAssetCategories1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new long[]{this._healthCategoryId});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetCategories2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new long[]{this._healthCategoryId, this._sportCategoryId});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetCategories3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._foodCategoryId});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetCategories4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new long[]{this._fashionCategoryId, this._foodCategoryId});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAnyAssetTags1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new String[]{"liferay"});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetTags2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new String[]{"liferay", "architecture"});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetTags3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new String[]{"liferay", "architecture", "services"});
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testAnyAssetTags4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, null, new String[]{"modularity", "osgi"});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetCategoryAllAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._travelCategoryId}, new long[]{this._healthCategoryId});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetCategoryNotAllAndAll() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._fashionCategoryId, this._foodCategoryId}, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._travelCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetCategoryNotAllAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._fashionCategoryId}, null, null, new long[]{this._sportCategoryId, this._travelCategoryId});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetCategoryNotAllAndNotAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._fashionCategoryId, this._foodCategoryId}, new long[]{this._travelCategoryId}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testAssetCategoryNotAnyAndAll() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._fashionCategoryId}, new long[]{this._healthCategoryId, this._sportCategoryId}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetCategoryNotAnyAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._fashionCategoryId, this._foodCategoryId}, null, new long[]{this._healthCategoryId, this._sportCategoryId, this._travelCategoryId});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetTagsAllAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, null, new String[]{"liferay", "architecture", "services"}, new String[]{"liferay"});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetTagsNotAllAndAll() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"osgi", "modularity"}, null, new String[]{"liferay", "architecture", "services"}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetTagsNotAllAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"services"}, null, null, new String[]{"liferay", "architecture"});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetTagsNotAllAndNotAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"osgi", "modularity"}, new String[]{"services"}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testAssetTagsNotAnyAndAll() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"modularity"}, new String[]{"liferay", "architecture"}, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testAssetTagsNotAnyAndAny() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"modularity", "osgi"}, null, new String[]{"liferay", "architecture", "services"});
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testClassName1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        this.testClassNames(assetEntryQuery, 1);
    }

    @Test
    public void testClassName2() throws Exception {
        long[] classNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)TestPropsValues.getCompanyId());
        classNameIds = ArrayUtil.remove((long[])classNameIds, (long)PortalUtil.getClassNameId(this.getBaseModelClass()));
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), classNameIds);
        this.testClassNames(assetEntryQuery, 0);
    }

    @Test
    public void testClassTypeIds1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        this.testClassTypeIds(assetEntryQuery, true);
    }

    @Test
    public void testClassTypeIds2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        this.testClassTypeIds(assetEntryQuery, false);
    }

    @Test
    public void testGroups() throws Exception {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassName(this.getBaseModelClassName());
        Group group1 = GroupTestUtil.addGroup();
        Group group2 = GroupTestUtil.addGroup();
        assetEntryQuery.setGroupIds(new long[]{group1.getGroupId(), group2.getGroupId()});
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        int initialEntries = 0;
        this.assertCount(initialEntries, assetEntryQuery, searchContext);
        ServiceContext serviceContext1 = ServiceContextTestUtil.getServiceContext((long)group1.getGroupId());
        BaseModel<?> parentBaseModel1 = this.getParentBaseModel(group1, serviceContext1);
        this.addBaseModel(parentBaseModel1, this.getSearchKeywords(), serviceContext1);
        ServiceContext serviceContext2 = ServiceContextTestUtil.getServiceContext((long)group2.getGroupId());
        BaseModel<?> parentBaseModel2 = this.getParentBaseModel(group1, serviceContext2);
        this.addBaseModel(parentBaseModel2, this.getSearchKeywords(), serviceContext2);
        this.assertCount(initialEntries + 2, assetEntryQuery, searchContext);
    }

    @Test
    public void testNotAllAssetCategories1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._healthCategoryId}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetCategories2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._healthCategoryId, this._sportCategoryId}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetCategories3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._fashionCategoryId, this._foodCategoryId}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testNotAllAssetCategories4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new long[]{this._fashionCategoryId, this._foodCategoryId, this._travelCategoryId}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testNotAllAssetTags1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"liferay"}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetTags2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"liferay", "architecture"}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetTags3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"liferay", "architecture", "services"}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testNotAllAssetTags4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), new String[]{"liferay", "architecture", "services", "osgi"}, null, null, null);
        this.testAssetCategorization(assetEntryQuery, 2);
    }

    @Test
    public void testNotAllAssetTagsMultipleGroups1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), new String[]{"liferay"}, null, null, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetTagsMultipleGroups2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), new String[]{"liferay", "architecture"}, null, null, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 0);
    }

    @Test
    public void testNotAllAssetTagsMultipleGroups3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), new String[]{"liferay", "architecture", "services"}, null, null, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 2);
    }

    @Test
    public void testNotAllAssetTagsMultipleGroups4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{this._group1.getGroupId(), this._group2.getGroupId()}, this.getBaseModelClassName(), new String[]{"liferay", "architecture", "services", "osgi"}, null, null, null);
        this.testAssetCategorization(new Group[]{this._group1, this._group2}, assetEntryQuery, 4);
    }

    @Test
    public void testNotAnyAssetCategories1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._healthCategoryId}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetCategories2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._healthCategoryId, this._sportCategoryId}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetCategories3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._fashionCategoryId, this._foodCategoryId, this._travelCategoryId}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetCategories4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new long[]{this._fashionCategoryId, this._foodCategoryId}, null, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testNotAnyAssetTags1() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"liferay"}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetTags2() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"liferay", "architecture"}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetTags3() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"liferay", "architecture", "services"}, null, null);
        this.testAssetCategorization(assetEntryQuery, 0);
    }

    @Test
    public void testNotAnyAssetTags4() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), this.getBaseModelClassName(), null, new String[]{"modularity", "osgi"}, null, null);
        this.testAssetCategorization(assetEntryQuery, 1);
    }

    @Test
    public void testOrderByCreateDateAsc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        String[] titles = new String[]{"open", "liferay", "social", "osgi", "content", "life"};
        this.testOrderByCreateDate(assetEntryQuery, "asc", titles, titles);
    }

    @Test
    public void testOrderByCreateDateDesc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        this.testOrderByCreateDate(assetEntryQuery, "desc", new String[]{"open", "liferay", "social", "osgi", "content", "life"}, new String[]{"life", "content", "osgi", "social", "liferay", "open"});
    }

    @Test
    public void testOrderByExpirationDateAsc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        Date[] expirationDates = this.generateRandomDates(new Date(), 6);
        this.testOrderByExpirationDate(assetEntryQuery, "asc", expirationDates);
    }

    @Test
    public void testOrderByExpirationDateDesc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        Date[] expirationDates = this.generateRandomDates(new Date(), 6);
        this.testOrderByExpirationDate(assetEntryQuery, "desc", expirationDates);
    }

    @Test
    public void testOrderByTitleAsc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        String[] defaultTitles = new String[]{"open", "liferay", "content", "social", "osgi", "life"};
        String[] frenchTitles = new String[]{"ouvert", "liferay", "content", "social", "osgi", "vie"};
        ArrayList<Map<Locale, String>> titleMaps = new ArrayList<Map<Locale, String>>();
        for (int i = 0; i < defaultTitles.length; ++i) {
            titleMaps.add(HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)defaultTitles[i]).put((Object)LocaleUtil.FRANCE, (Object)frenchTitles[i]).build());
        }
        String[] defaultOrderedTitles = new String[]{"content", "life", "liferay", "open", "osgi", "social"};
        String[] frenchOrderedTitles = new String[]{"content", "liferay", "osgi", "ouvert", "social", "vie"};
        ArrayList<Map<Locale, String>> orderedTitleMaps = new ArrayList<Map<Locale, String>>();
        for (int i = 0; i < defaultOrderedTitles.length; ++i) {
            HashMap titleMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)defaultOrderedTitles[i]).build();
            String orderedTitle = frenchOrderedTitles[i];
            if (!this.isLocalizableTitle()) {
                orderedTitle = defaultOrderedTitles[i];
            }
            titleMap.put(LocaleUtil.FRANCE, orderedTitle);
            orderedTitleMaps.add(titleMap);
        }
        this.testOrderByTitle(assetEntryQuery, "asc", titleMaps, orderedTitleMaps, new Locale[]{LocaleUtil.getDefault(), LocaleUtil.FRANCE});
    }

    @Test
    public void testOrderByTitleDesc() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        String[] defaultTitles = new String[]{"open", "liferay", "content", "social", "osgi", "life"};
        String[] frenchTitles = new String[]{"ouvert", "liferay", "content", "social", "osgi", "vie"};
        ArrayList<Map<Locale, String>> titleMaps = new ArrayList<Map<Locale, String>>();
        for (int i = 0; i < defaultTitles.length; ++i) {
            titleMaps.add(HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)defaultTitles[i]).put((Object)LocaleUtil.FRANCE, (Object)frenchTitles[i]).build());
        }
        String[] defaultOrderedTitles = new String[]{"social", "osgi", "open", "liferay", "life", "content"};
        String[] frenchOrderedTitles = new String[]{"vie", "social", "ouvert", "osgi", "liferay", "content"};
        ArrayList<Map<Locale, String>> orderedTitleMaps = new ArrayList<Map<Locale, String>>();
        for (int i = 0; i < defaultOrderedTitles.length; ++i) {
            HashMap titleMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)defaultOrderedTitles[i]).build();
            String orderedTitle = frenchOrderedTitles[i];
            if (!this.isLocalizableTitle()) {
                orderedTitle = defaultOrderedTitles[i];
            }
            titleMap.put(LocaleUtil.FRANCE, orderedTitle);
            orderedTitleMaps.add(titleMap);
        }
        this.testOrderByTitle(assetEntryQuery, "desc", titleMaps, orderedTitleMaps, new Locale[]{LocaleUtil.getDefault(), LocaleUtil.FRANCE});
    }

    @Test
    public void testPaginationTypeNone() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        assetEntryQuery.setPaginationType("none");
        this.testPaginationType(assetEntryQuery, 5);
    }

    @Test
    public void testPaginationTypeRegular() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        assetEntryQuery.setPaginationType("regular");
        this.testPaginationType(assetEntryQuery, 5);
    }

    @Test
    public void testPaginationTypeSimple() throws Exception {
        AssetEntryQuery assetEntryQuery = AssetEntryQueryTestUtil.createAssetEntryQuery(this._group1.getGroupId(), new String[]{this.getBaseModelClassName()});
        assetEntryQuery.setPaginationType("simple");
        this.testPaginationType(assetEntryQuery, 5);
    }

    protected abstract BaseModel<?> addBaseModel(BaseModel<?> var1, Map<Locale, String> var2, ServiceContext var3) throws Exception;

    protected BaseModel<?> addBaseModel(BaseModel<?> parentBaseModel, String keywords, Date expirationDate, ServiceContext serviceContext) throws Exception {
        return this.addBaseModel(parentBaseModel, keywords, serviceContext);
    }

    protected abstract BaseModel<?> addBaseModel(BaseModel<?> var1, String var2, ServiceContext var3) throws Exception;

    protected List<BaseModel<?>> addBaseModels(Group[] groups, String keywords, ServiceContext serviceContext) throws Exception {
        ArrayList baseModels = new ArrayList();
        for (Group group : groups) {
            User user = UserTestUtil.getAdminUser((long)group.getCompanyId());
            serviceContext.setCompanyId(group.getCompanyId());
            serviceContext.setScopeGroupId(group.getGroupId());
            serviceContext.setUserId(user.getUserId());
            baseModels.add(this.addBaseModel(this.getParentBaseModel(group, serviceContext), keywords, serviceContext));
        }
        return baseModels;
    }

    protected BaseModel<?> addBaseModelWithClassType(BaseModel<?> parentBaseModel, String keywords, ServiceContext serviceContext) throws Exception {
        return this.addBaseModel(parentBaseModel, keywords, serviceContext);
    }

    protected BaseModel<?> addBaseModelWithWorkflow(BaseModel<?> parentBaseModel, String keywords, boolean approved, ServiceContext serviceContext) throws Exception {
        return this.addBaseModel(parentBaseModel, keywords, serviceContext);
    }

    protected void assertCount(int expectedCount, AssetEntryQuery assetEntryQuery, SearchContext searchContext) throws Exception {
        this.assertCount(expectedCount, assetEntryQuery, searchContext, -1, -1);
    }

    protected void assertCount(int expectedCount, AssetEntryQuery assetEntryQuery, SearchContext searchContext, int start, int end) throws Exception {
        int actualCount = this.searchCount(assetEntryQuery, searchContext, start, end);
        Assert.assertEquals((long)expectedCount, (long)actualCount);
    }

    protected String[] format(Date[] dates, DateFormat dateFormat) {
        String[] strings = new String[dates.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = dateFormat.format(dates[i]);
        }
        return strings;
    }

    protected Date[] generateRandomDates(Date startDate, int size) {
        Date[] dates = new Date[size];
        for (int i = 0; i < size; ++i) {
            Date date = new Date(startDate.getTime() + (long)(RandomUtil.nextInt((int)365) + 1) * 86400000L);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dates[i] = calendar.getTime();
        }
        return dates;
    }

    protected abstract Class<?> getBaseModelClass();

    protected String getBaseModelClassName() {
        Class<?> clazz = this.getBaseModelClass();
        return clazz.getName();
    }

    protected long[] getClassTypeIds() {
        return null;
    }

    protected Date[] getExpirationDates(List<AssetEntry> assetEntries, String orderByType) throws Exception {
        Date[] dates = new Date[assetEntries.size()];
        for (int i = 0; i < dates.length; ++i) {
            int index = i;
            if (orderByType.equals("desc")) {
                index = dates.length - 1 - i;
            }
            AssetEntry assetEntry = assetEntries.get(index);
            dates[i] = assetEntry.getExpirationDate();
        }
        return dates;
    }

    protected String[] getOrderedTitles(List<Map<Locale, String>> orderedTitleMaps, Locale locale) throws Exception {
        String[] titles = new String[orderedTitleMaps.size()];
        for (int i = 0; i < titles.length; ++i) {
            Map<Locale, String> orderedTitleMap = orderedTitleMaps.get(i);
            titles[i] = orderedTitleMap.get(locale);
        }
        return titles;
    }

    protected BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected abstract String getSearchKeywords();

    protected String[] getTitles(List<AssetEntry> assetEntries, Locale locale) throws Exception {
        String[] titles = new String[assetEntries.size()];
        for (int i = 0; i < titles.length; ++i) {
            AssetEntry assetEntry = assetEntries.get(i);
            titles[i] = assetEntry.getTitle(locale);
        }
        return titles;
    }

    protected boolean isLocalizableTitle() {
        return true;
    }

    protected List<AssetEntry> search(AssetEntryQuery assetEntryQuery, SearchContext searchContext) throws Exception {
        Hits results = this._assetHelper.search(searchContext, assetEntryQuery, -1, -1);
        return this._assetHelper.getAssetEntries(results);
    }

    protected int searchCount(AssetEntryQuery assetEntryQuery, SearchContext searchContext, int start, int end) throws Exception {
        Hits results = this._assetHelper.search(searchContext, assetEntryQuery, start, end);
        return results.getLength();
    }

    protected void testAssetCategorization(AssetEntryQuery assetEntryQuery, int expectedResults) throws Exception {
        this.testAssetCategorization(new Group[]{this._group1}, assetEntryQuery, expectedResults);
    }

    protected void testAssetCategorization(Group[] groups, AssetEntryQuery assetEntryQuery, int expectedResults) throws Exception {
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        int initialEntries = 0;
        this.assertCount(initialEntries, assetEntryQuery, searchContext);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groups[0].getGroupId());
        serviceContext.setAssetCategoryIds(this._assetCategoryIds1);
        serviceContext.setAssetTagNames(this._assetTagsNames1);
        this.addBaseModels(groups, this.getSearchKeywords(), serviceContext);
        serviceContext.setAssetCategoryIds(this._assetCategoryIds2);
        serviceContext.setAssetTagNames(this._assetTagsNames2);
        this.addBaseModels(groups, this.getSearchKeywords(), serviceContext);
        this.assertCount(initialEntries + expectedResults, assetEntryQuery, searchContext);
    }

    protected void testClassNames(AssetEntryQuery assetEntryQuery, int expectedResult) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this._group1, serviceContext);
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        int initialEntries = 0;
        this.assertCount(initialEntries, assetEntryQuery, searchContext);
        this.addBaseModel(parentBaseModel, this.getSearchKeywords(), serviceContext);
        this.assertCount(initialEntries + expectedResult, assetEntryQuery, searchContext);
    }

    protected void testClassTypeIds(AssetEntryQuery assetEntryQuery, boolean classType) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this._group1, serviceContext);
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        int initialEntries = 0;
        this.assertCount(initialEntries, assetEntryQuery, searchContext);
        this.addBaseModelWithClassType(parentBaseModel, this.getSearchKeywords(), serviceContext);
        if (classType) {
            assetEntryQuery.setClassTypeIds(this.getClassTypeIds());
            this.assertCount(initialEntries + 1, assetEntryQuery, searchContext);
        } else {
            assetEntryQuery.setClassTypeIds(new long[]{0L});
            this.assertCount(initialEntries, assetEntryQuery, searchContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testOrderByCreateDate(AssetEntryQuery assetEntryQuery, String orderByType, String[] titles, String[] orderedTitles) throws Exception {
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        for (String title : titles) {
            ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
            serviceContext.setCreateDate(new Date());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            try {
                this.addBaseModel(this.getParentBaseModel(this._group1, serviceContext), title, serviceContext);
            }
            finally {
                ServiceContextThreadLocal.popServiceContext();
            }
        }
        assetEntryQuery.setOrderByCol1("createDate");
        assetEntryQuery.setOrderByType1(orderByType);
        List<AssetEntry> assetEntries = this.search(assetEntryQuery, searchContext);
        Assert.assertEquals((Object)ArrayUtils.toString((Object)orderedTitles), (Object)ArrayUtils.toString((Object)this.getTitles(assetEntries, LocaleUtil.getDefault())));
    }

    protected void testOrderByExpirationDate(AssetEntryQuery assetEntryQuery, String orderByType, Date[] expirationDates) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this._group1, serviceContext);
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        for (Date expirationDate : expirationDates) {
            this.addBaseModel(parentBaseModel, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), expirationDate, serviceContext);
        }
        assetEntryQuery.setOrderByCol1("expirationDate");
        assetEntryQuery.setOrderByType1(orderByType);
        Arrays.sort(expirationDates);
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
        List<AssetEntry> assetEntries = this.search(assetEntryQuery, searchContext);
        Assert.assertEquals((Object)ArrayUtils.toString((Object)this.format(expirationDates, dateFormat)), (Object)ArrayUtils.toString((Object)this.format(this.getExpirationDates(assetEntries, orderByType), dateFormat)));
    }

    protected void testOrderByTitle(AssetEntryQuery assetEntryQuery, String orderByType, List<Map<Locale, String>> titleMaps, List<Map<Locale, String>> orderedTitleMaps, Locale[] locales) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this._group1, serviceContext);
        for (Map<Locale, String> titleMap : titleMaps) {
            this.addBaseModel(parentBaseModel, titleMap, serviceContext);
        }
        assetEntryQuery.setOrderByCol1("title");
        assetEntryQuery.setOrderByType1(orderByType);
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        for (Locale locale : locales) {
            searchContext.setLocale(locale);
            List<AssetEntry> assetEntries = this.search(assetEntryQuery, searchContext);
            Assert.assertEquals((Object)ArrayUtils.toString((Object)this.getOrderedTitles(orderedTitleMaps, locale)), (Object)ArrayUtils.toString((Object)this.getTitles(assetEntries, locale)));
        }
    }

    protected void testPaginationType(AssetEntryQuery assetEntryQuery, int size) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this._group1.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this._group1, serviceContext);
        SearchContext searchContext = SearchContextTestUtil.getSearchContext();
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        for (int i = 0; i < size; ++i) {
            this.addBaseModel(parentBaseModel, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        }
        this.assertCount(size, assetEntryQuery, searchContext, 0, 1);
    }
}

