/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.vocabulary.item.selector.web.internal;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.item.selector.ItemSelectorViewDescriptor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class AssetVocabularyItemDescriptor
implements ItemSelectorViewDescriptor.ItemDescriptor {
    private static final Log _log = LogFactoryUtil.getLog(AssetVocabularyItemDescriptor.class);
    private final AssetVocabulary _assetVocabulary;
    private final HttpServletRequest _httpServletRequest;

    public AssetVocabularyItemDescriptor(AssetVocabulary assetVocabulary, HttpServletRequest httpServletRequest) {
        this._assetVocabulary = assetVocabulary;
        this._httpServletRequest = httpServletRequest;
    }

    public String getIcon() {
        return "vocabulary";
    }

    public String getImageURL() {
        return null;
    }

    public Date getModifiedDate() {
        return this._assetVocabulary.getModifiedDate();
    }

    public String getPayload() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return JSONUtil.put((String)"assetVocabularyId", (Object)String.valueOf(this._assetVocabulary.getVocabularyId())).put("groupId", String.valueOf(this._assetVocabulary.getGroupId())).put("title", this._assetVocabulary.getTitle(themeDisplay.getLocale())).put("uuid", this._assetVocabulary.getUuid()).toString();
    }

    public String getSubtitle(Locale locale) {
        return LanguageUtil.format((Locale)locale, (String)"x-categories", (Object)this._assetVocabulary.getCategoriesCount());
    }

    public String getTitle(Locale locale) {
        StringBundler sb;
        block4: {
            sb = new StringBundler(5);
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            sb.append(HtmlUtil.escape((String)this._assetVocabulary.getTitle(themeDisplay.getLocale())));
            sb.append(" ");
            sb.append("(");
            if (this._assetVocabulary.getGroupId() == themeDisplay.getCompanyGroupId()) {
                sb.append(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"global"));
            } else {
                try {
                    Group group = GroupLocalServiceUtil.getGroup((long)this._assetVocabulary.getGroupId());
                    sb.append(group.getDescriptiveName(themeDisplay.getLocale()));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public long getUserId() {
        return this._assetVocabulary.getUserId();
    }

    public String getUserName() {
        return this._assetVocabulary.getUserName();
    }

    public boolean isCompact() {
        return true;
    }
}

