/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.rest.internal.vulcan.batch.engine;

import com.liferay.batch.planner.rest.internal.vulcan.yaml.openapi.OpenAPIYAMLProvider;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResourceProvider;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.util.OpenAPIUtil;
import com.liferay.portal.vulcan.yaml.openapi.OpenAPIYAML;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FieldProvider.class})
public class FieldProvider {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryOpenAPIResourceProvider _objectEntryOpenAPIResourceProvider;
    @Reference
    private OpenAPIYAMLProvider _openAPIYAMLProvider;

    public List<Field> filter(List<Field> fields, Field.AccessType ignoredAccessType) {
        return ListUtil.filter(fields, dtoEntityField -> {
            if (dtoEntityField.getAccessType() == ignoredAccessType) {
                return false;
            }
            String name = dtoEntityField.getName();
            return !name.equals("actions") && !name.startsWith("x-");
        });
    }

    public List<Field> getFields(long companyId, String internalClassName, UriInfo uriInfo) throws Exception {
        int index = internalClassName.indexOf("#");
        if (index < 0) {
            OpenAPIYAML openAPIYAML = this._openAPIYAMLProvider.getOpenAPIYAML(companyId, internalClassName);
            return ListUtil.fromMapValues((Map)OpenAPIUtil.getDTOEntityFields((String)StringUtil.extractLast((String)internalClassName, (String)"."), (OpenAPIYAML)openAPIYAML));
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(companyId, internalClassName.substring(index + 1));
        ObjectEntryOpenAPIResource objectEntryOpenAPIResource = this._objectEntryOpenAPIResourceProvider.getObjectEntryOpenAPIResource(objectDefinition);
        Map fields = objectEntryOpenAPIResource.getFields(uriInfo);
        return TransformUtil.transform(fields.values(), field -> {
            if ((Objects.equals(field.getType(), "array") || Objects.equals(field.getType(), "object")) && !Validator.isBlank((String)field.getRef())) {
                return null;
            }
            return field;
        });
    }
}

