/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import ClayButton from '@clayui/button';
import {useModal} from '@clayui/modal';
import PropTypes from 'prop-types';
import React, {useCallback, useEffect, useState} from 'react';

import {SCHEMA_SELECTED_EVENT} from '../constants';
import ExportModal from './ExportModal';

function Export({
	formExportDataQuerySelector,
	formExportURL,
	portletNamespace,
}) {
	const [disable, setDisable] = useState(true);
	const [visible, setVisible] = useState(false);
	const {observer, onClose} = useModal({
		onClose: () => setVisible(false),
	});

	const onButtonClick = useCallback(
		(event) => {
			event.preventDefault();

			setVisible(true);
		},
		[setVisible]
	);

	useEffect(() => {
		function handleSchemaChange(event) {
			if (event.schema) {
				setDisable(false);
			}
		}
		Liferay.on(SCHEMA_SELECTED_EVENT, handleSchemaChange);

		return () => Liferay.detach(SCHEMA_SELECTED_EVENT, handleSchemaChange);
	}, [portletNamespace]);

	return (
		<>
			<ClayButton
				disabled={disable}
				displayType="primary"
				id={`${portletNamespace}saveTemplate`}
				onClick={onButtonClick}
				type="submit"
			>
				{Liferay.Language.get('export')}
			</ClayButton>

			{visible && (
				<ExportModal
					closeModal={onClose}
					formDataQuerySelector={formExportDataQuerySelector}
					formSubmitURL={formExportURL}
					namespace={portletNamespace}
					observer={observer}
				/>
			)}
		</>
	);
}

Export.propTypes = {
	formExportDataQuerySelector: PropTypes.string.isRequired,
	formExportURL: PropTypes.string.isRequired,
	portletNamespace: PropTypes.string.isRequired,
};

export default Export;
