/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanValidationMessageInterpolator;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeanValidationValidator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.validation.MessageInterpolator;
import javax.validation.NoProviderFoundException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

@ApplicationScoped
public class BeanValidationProducer {
    private static final Log _log = LogFactoryUtil.getLog(BeanValidationProducer.class);
    private MessageInterpolator _messageInterpolator;
    private Validator _validator;
    @Inject
    private Instance<ValidatorFactory> _validatorFactoryInstance;

    @BeanValidationMessageInterpolator
    @Dependent
    @Produces
    public MessageInterpolator getMessageInterpolator() {
        return this._messageInterpolator;
    }

    @BeanValidationValidator
    @Dependent
    @Produces
    public Validator getValidator() {
        return this._validator;
    }

    @PostConstruct
    public void postConstruct() {
        ValidatorFactory validatorFactory = null;
        Iterator iterator = this._validatorFactoryInstance.iterator();
        if (iterator.hasNext()) {
            validatorFactory = (ValidatorFactory)iterator.next();
        }
        if (validatorFactory == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"The ValidatorFactory was not injected. If you are using Hibernate Validator, then include the hibernate-validator-cdi dependency.");
            }
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (NoProviderFoundException noProviderFoundException) {
                _log.error((Object)noProviderFoundException, (Throwable)noProviderFoundException);
            }
        }
        if (validatorFactory != null) {
            this._messageInterpolator = validatorFactory.getMessageInterpolator();
            if (this._messageInterpolator == null && _log.isWarnEnabled()) {
                _log.warn((Object)"The bean validation MessageInterpolator is not available");
            }
            this._validator = validatorFactory.getValidator();
            if (this._validator == null && _log.isWarnEnabled()) {
                _log.warn((Object)"The bean validation validator is not available");
            }
        }
    }
}

