/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.AfterControllerEventImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.BeforeControllerEventImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ControllerInterceptorBinding;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ControllerRedirectEventImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.ResourceInfoImpl;
import com.liferay.bean.portlet.cdi.extension.internal.mvc.UriInfoImpl;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.View;
import javax.mvc.event.MvcEvent;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.MutableResourceParameters;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.ResourceResponse;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.InitMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.filter.RenderURLWrapper;
import javax.portlet.filter.ResourceURLWrapper;

@ControllerInterceptorBinding
@Interceptor
@Priority(value=1000)
public class ControllerInterceptor
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(ControllerInterceptor.class);
    private static final long serialVersionUID = 1573287230987622411L;
    @Inject
    private ActionResponse _actionResponse;
    @Inject
    private Event<MvcEvent> _mvcEvent;
    @Inject
    private PortletRequest _portletRequest;
    @Inject
    private RenderParameters _renderParameters;
    @Inject
    private ResourceResponse _resourceResponse;

    @AroundInvoke
    public Object processView(InvocationContext invocationContext) throws Exception {
        String actionPhaseViewName = null;
        Method invocationContextMethod = invocationContext.getMethod();
        BeanPortletMethodType beanPortletMethodType = this._getMethodType(invocationContextMethod);
        if ((beanPortletMethodType == BeanPortletMethodType.RENDER || beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE) && this._renderParameters.getValue("redirectedView") != null) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            actionPhaseViewName = (String)portletSession.getAttribute("viewName");
            portletSession.removeAttribute("viewName");
            if (actionPhaseViewName != null) {
                this._portletRequest.setAttribute("viewName", (Object)actionPhaseViewName);
            }
        }
        Object target = invocationContext.getTarget();
        this._mvcEvent.fire((Object)new BeforeControllerEventImpl(new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl()));
        Object result = invocationContext.proceed();
        Object redirectURL = null;
        boolean renderView = true;
        String viewName = null;
        if (Validator.isNull((Object)result)) {
            View view = invocationContextMethod.getAnnotation(View.class);
            if (view != null) {
                viewName = view.value();
            }
        } else {
            viewName = result.toString();
        }
        if (Validator.isNotNull((String)viewName) && (beanPortletMethodType == BeanPortletMethodType.ACTION || beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE)) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            if (viewName.startsWith("redirect:")) {
                viewName = viewName.substring("redirect:".length());
                redirectURL = beanPortletMethodType == BeanPortletMethodType.ACTION ? new ActionRedirectURL(this._actionResponse) : new ResourceRedirectURL(this._resourceResponse);
            }
            portletSession.setAttribute("viewName", (Object)viewName);
            if (beanPortletMethodType == BeanPortletMethodType.ACTION) {
                if (redirectURL == null) {
                    MutableRenderParameters mutableRenderParameters = this._actionResponse.getRenderParameters();
                    mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
                } else {
                    try {
                        this._actionResponse.sendRedirect(redirectURL.toString());
                    }
                    catch (IOException ioException) {
                        _log.error((Object)ioException, (Throwable)ioException);
                    }
                }
            } else if (redirectURL != null) {
                this._resourceResponse.setStatus(302);
                this._resourceResponse.addProperty("Location", redirectURL.toString());
                renderView = false;
            }
        }
        if (renderView) {
            if (Validator.isNull((String)viewName)) {
                viewName = actionPhaseViewName;
            }
            if (Validator.isNotNull((String)viewName)) {
                this._portletRequest.setAttribute("viewName", (Object)viewName);
            }
        }
        target = invocationContext.getTarget();
        this._mvcEvent.fire((Object)new AfterControllerEventImpl(new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl()));
        if (redirectURL != null) {
            try {
                URI uri = new URI(redirectURL.toString());
                this._mvcEvent.fire((Object)new ControllerRedirectEventImpl(uri, new ResourceInfoImpl(target.getClass(), invocationContextMethod), new UriInfoImpl()));
            }
            catch (URISyntaxException uriSyntaxException) {
                _log.error((Object)uriSyntaxException, (Throwable)uriSyntaxException);
            }
        }
        return null;
    }

    private BeanPortletMethodType _getMethodType(Method invocationContextMethod) {
        if (invocationContextMethod.isAnnotationPresent(ActionMethod.class)) {
            return BeanPortletMethodType.ACTION;
        }
        if (invocationContextMethod.isAnnotationPresent(DestroyMethod.class)) {
            return BeanPortletMethodType.DESTROY;
        }
        if (invocationContextMethod.isAnnotationPresent(EventMethod.class)) {
            return BeanPortletMethodType.EVENT;
        }
        if (invocationContextMethod.isAnnotationPresent(InitMethod.class)) {
            return BeanPortletMethodType.INIT;
        }
        if (invocationContextMethod.isAnnotationPresent(RenderMethod.class)) {
            return BeanPortletMethodType.RENDER;
        }
        return BeanPortletMethodType.SERVE_RESOURCE;
    }

    private static class ResourceRedirectURL
    extends ResourceURLWrapper {
        private ResourceRedirectURL(ResourceResponse resourceResponse) {
            super(resourceResponse.createResourceURL());
            MutableResourceParameters mutableResourceParameters = this.getResourceParameters();
            mutableResourceParameters.setValue("redirectedView", Boolean.TRUE.toString());
        }
    }

    private static class ActionRedirectURL
    extends RenderURLWrapper {
        private ActionRedirectURL(ActionResponse actionResponse) {
            super(actionResponse.createRedirectURL(MimeResponse.Copy.ALL));
            MutableRenderParameters mutableRenderParameters = this.getRenderParameters();
            mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
        }
    }
}

