/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.cdi.extension.internal.mvc;

import com.liferay.bean.portlet.cdi.extension.internal.mvc.CsrfValidationInterceptorBinding;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.mvc.security.Csrf;
import javax.mvc.security.CsrfProtected;
import javax.portlet.ClientDataRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Configuration;

@CsrfValidationInterceptorBinding
@Interceptor
@Priority(value=1000)
public class CsrfValidationInterceptor
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(CsrfValidationInterceptor.class);
    private static final long serialVersionUID = 1348567603498123441L;
    @Inject
    private Configuration _configuration;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext invocationContext) throws Exception {
        Csrf.CsrfOptions csrfOptions = Csrf.CsrfOptions.EXPLICIT;
        Object csrfProtection = this._configuration.getProperty("javax.mvc.security.CsrfProtection");
        if (csrfProtection != null) {
            if (csrfProtection instanceof Csrf.CsrfOptions) {
                csrfOptions = (Csrf.CsrfOptions)csrfProtection;
            } else {
                try {
                    csrfOptions = Csrf.CsrfOptions.valueOf((String)csrfProtection.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    _log.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
                }
            }
        }
        if (csrfOptions == Csrf.CsrfOptions.OFF) {
            return invocationContext.proceed();
        }
        Method method = invocationContext.getMethod();
        if (csrfOptions == Csrf.CsrfOptions.EXPLICIT && !method.isAnnotationPresent(CsrfProtected.class)) {
            return invocationContext.proceed();
        }
        boolean proceed = false;
        Object[] args = invocationContext.getParameters();
        if (args.length == 2) {
            if (args[0] instanceof ClientDataRequest) {
                ClientDataRequest clientDataRequest = (ClientDataRequest)args[0];
                String requestMethod = StringUtil.toLowerCase((String)clientDataRequest.getMethod());
                if (requestMethod.equals("post")) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)clientDataRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    try {
                        AuthTokenUtil.checkCSRFToken((HttpServletRequest)themeDisplay.getRequest(), (String)CsrfValidationInterceptor.class.getName());
                        proceed = true;
                    }
                    catch (PrincipalException principalException) {
                        _log.error((Object)"The CSRF token is invalid", (Throwable)principalException);
                    }
                } else {
                    proceed = true;
                }
            } else {
                _log.error((Object)"The first parameter of the method signature must be an ActionRequest or ResourceRequest");
            }
        } else {
            _log.error((Object)"The method signature must include (ActionRequest, ActionResponse) or (ResourceRequest, ResourceResponse) as parameters");
        }
        if (proceed) {
            return invocationContext.proceed();
        }
        return null;
    }
}

