/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.extension;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.portlet.PortletMode;
import javax.portlet.ProcessAction;
import javax.portlet.RenderMode;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.HeaderMethod;
import javax.portlet.annotations.PortletQName;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.xml.namespace.QName;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseBeanPortletMethod
implements BeanPortletMethod {
    private final BeanPortletMethodType _beanPortletMethodType;
    private final Method _method;
    private final int _ordinal;

    public BaseBeanPortletMethod(BeanPortletMethodType beanPortletMethodType, Method method) {
        this._beanPortletMethodType = beanPortletMethodType;
        this._method = method;
        this._ordinal = beanPortletMethodType.getOrdinal(method);
    }

    @Override
    public int compareTo(BeanPortletMethod beanPortletMethod) {
        return Integer.compare(this._ordinal, beanPortletMethod.getOrdinal());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BeanPortletMethod)) {
            return false;
        }
        BaseBeanPortletMethod baseBeanPortletMethod = (BaseBeanPortletMethod)object;
        return Objects.equals((Object)this._beanPortletMethodType, (Object)baseBeanPortletMethod._beanPortletMethodType) && Objects.equals(this._method, baseBeanPortletMethod._method) && Objects.equals(this._ordinal, baseBeanPortletMethod._ordinal);
    }

    @Override
    public String getActionName() {
        String actionName;
        ActionMethod actionMethod = this._method.getAnnotation(ActionMethod.class);
        if (actionMethod != null && Validator.isNotNull((String)(actionName = actionMethod.actionName()))) {
            return actionName;
        }
        ProcessAction processAction = this._method.getAnnotation(ProcessAction.class);
        if (processAction == null) {
            return null;
        }
        return processAction.name();
    }

    @Override
    public BeanPortletMethodType getBeanPortletMethodType() {
        return this._beanPortletMethodType;
    }

    @Override
    public Method getMethod() {
        return this._method;
    }

    @Override
    public int getOrdinal() {
        return this._ordinal;
    }

    @Override
    public PortletMode getPortletMode() {
        HeaderMethod headerMethod = this._method.getAnnotation(HeaderMethod.class);
        if (headerMethod != null) {
            String portletMode = headerMethod.portletMode();
            if (Validator.isNull((String)portletMode)) {
                return null;
            }
            return new PortletMode(portletMode);
        }
        RenderMethod renderMethod = this._method.getAnnotation(RenderMethod.class);
        if (renderMethod != null) {
            String portletMode = renderMethod.portletMode();
            if (Validator.isNull((String)portletMode)) {
                return null;
            }
            return new PortletMode(portletMode);
        }
        RenderMode renderMode = this._method.getAnnotation(RenderMode.class);
        if (renderMode == null) {
            return null;
        }
        String name = renderMode.name();
        if (Validator.isNull((String)name)) {
            return null;
        }
        return new PortletMode(name);
    }

    @Override
    public String getResourceID() {
        String resourceID;
        ServeResourceMethod serveResourceMethod = this._method.getAnnotation(ServeResourceMethod.class);
        if (serveResourceMethod != null && Validator.isNotNull((String)(resourceID = serveResourceMethod.resourceID()))) {
            return resourceID;
        }
        return null;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)((Object)this._beanPortletMethodType));
        hashCode = HashUtil.hash((int)hashCode, (Object)this._method);
        return HashUtil.hash((int)hashCode, (int)this._ordinal);
    }

    @Override
    public boolean isEventProcessor(QName qName) {
        PortletQName[] portletQNames;
        EventMethod eventMethod = this._method.getAnnotation(EventMethod.class);
        if (eventMethod == null) {
            return false;
        }
        for (PortletQName portletQName : portletQNames = eventMethod.processingEvents()) {
            String namespaceURI;
            String localPart = portletQName.localPart();
            if (!localPart.equals(qName.getLocalPart()) || !(namespaceURI = portletQName.namespaceURI()).equals(qName.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }
}

