/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.extension;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Function;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.HeaderMethod;
import javax.portlet.annotations.InitMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;

public enum BeanPortletMethodType {
    ACTION(ActionMethod.class, null, annotation -> null, true, annotation -> null, annotation -> 0, new Class[]{ActionRequest.class, ActionResponse.class}, annotation -> null, annotation -> {
        ActionMethod actionMethod = (ActionMethod)ActionMethod.class.cast(annotation);
        return new String[]{actionMethod.portletName()};
    }, false),
    DESTROY(DestroyMethod.class, null, annotation -> null, false, annotation -> null, annotation -> 0, new Class[0], annotation -> null, annotation -> {
        DestroyMethod destroyMethod = (DestroyMethod)DestroyMethod.class.cast(annotation);
        return new String[]{destroyMethod.value()};
    }, false),
    EVENT(EventMethod.class, null, annotation -> null, false, annotation -> null, annotation -> 0, new Class[]{EventRequest.class, EventResponse.class}, annotation -> null, annotation -> {
        EventMethod eventMethod = (EventMethod)EventMethod.class.cast(annotation);
        return new String[]{eventMethod.portletName()};
    }, false),
    HEADER(HeaderMethod.class, annotation -> null, annotation -> null, false, annotation -> {
        HeaderMethod headerMethod = (HeaderMethod)HeaderMethod.class.cast(annotation);
        return headerMethod.include();
    }, annotation -> {
        HeaderMethod headerMethod = (HeaderMethod)HeaderMethod.class.cast(annotation);
        return headerMethod.ordinal();
    }, new Class[]{HeaderRequest.class, HeaderResponse.class}, annotation -> {
        HeaderMethod headerMethod = (HeaderMethod)HeaderMethod.class.cast(annotation);
        return new PortletMode(headerMethod.portletMode());
    }, annotation -> {
        HeaderMethod headerMethod = (HeaderMethod)HeaderMethod.class.cast(annotation);
        return headerMethod.portletNames();
    }, true),
    INIT(InitMethod.class, null, annotation -> null, false, annotation -> null, annotation -> 0, new Class[]{PortletConfig.class}, annotation -> null, annotation -> {
        InitMethod initMethod = (InitMethod)InitMethod.class.cast(annotation);
        return new String[]{initMethod.value()};
    }, false),
    RENDER(RenderMethod.class, annotation -> null, annotation -> null, true, annotation -> {
        RenderMethod renderMethod = (RenderMethod)RenderMethod.class.cast(annotation);
        return renderMethod.include();
    }, annotation -> {
        RenderMethod renderMethod = (RenderMethod)RenderMethod.class.cast(annotation);
        return renderMethod.ordinal();
    }, new Class[]{RenderRequest.class, RenderResponse.class}, annotation -> {
        RenderMethod renderMethod = (RenderMethod)RenderMethod.class.cast(annotation);
        return new PortletMode(renderMethod.portletMode());
    }, annotation -> {
        RenderMethod renderMethod = (RenderMethod)RenderMethod.class.cast(annotation);
        return renderMethod.portletNames();
    }, true),
    SERVE_RESOURCE(ServeResourceMethod.class, annotation -> {
        ServeResourceMethod serveResourceMethod = (ServeResourceMethod)ServeResourceMethod.class.cast(annotation);
        return serveResourceMethod.characterEncoding();
    }, annotation -> {
        ServeResourceMethod serveResourceMethod = (ServeResourceMethod)ServeResourceMethod.class.cast(annotation);
        return serveResourceMethod.contentType();
    }, true, annotation -> {
        ServeResourceMethod serveResourceMethod = (ServeResourceMethod)ServeResourceMethod.class.cast(annotation);
        return serveResourceMethod.include();
    }, annotation -> {
        ServeResourceMethod serveResourceMethod = (ServeResourceMethod)ServeResourceMethod.class.cast(annotation);
        return serveResourceMethod.ordinal();
    }, new Class[]{ResourceRequest.class, ResourceResponse.class}, annotation -> PortletMode.VIEW, annotation -> {
        ServeResourceMethod serveResourceMethod = (ServeResourceMethod)ServeResourceMethod.class.cast(annotation);
        return serveResourceMethod.portletNames();
    }, true);

    private static final Log _log;
    private final Class<? extends Annotation> _annotation;
    private final Function<Annotation, String> _characterEncodingFunction;
    private final Function<Annotation, String> _contentTypeFunction;
    private final boolean _controller;
    private final Function<Annotation, String> _includeFunction;
    private final Function<Annotation, Integer> _ordinalFunction;
    private final Class<?>[] _parameterTypes;
    private final Function<Annotation, PortletMode> _portletModeFunction;
    private final Function<Annotation, String[]> _portletNamesFunction;
    private final boolean _variant;

    public String getCharacterEncoding(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null) {
            return null;
        }
        return this._characterEncodingFunction.apply(annotation);
    }

    public String getContentType(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null) {
            return null;
        }
        return this._contentTypeFunction.apply(annotation);
    }

    public String getInclude(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null) {
            return null;
        }
        return this._includeFunction.apply(annotation);
    }

    public int getOrdinal(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null) {
            return 0;
        }
        return this._ordinalFunction.apply(annotation);
    }

    public PortletMode getPortletMode(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null || this._portletModeFunction == null) {
            return null;
        }
        return this._portletModeFunction.apply(annotation);
    }

    public String[] getPortletNames(Method method) {
        Annotation annotation = method.getAnnotation(this._annotation);
        if (annotation == null) {
            return null;
        }
        return this._portletNamesFunction.apply(annotation);
    }

    public boolean isMatch(Method method) {
        if (!method.isAnnotationPresent(this._annotation)) {
            return false;
        }
        Class<?> returnClass = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (returnClass.equals(Void.TYPE) && this._isAssignableFrom(parameterTypes)) {
            return true;
        }
        if (this._variant && parameterTypes.length == 0 && (returnClass.equals(Void.TYPE) || returnClass.equals(String.class))) {
            return true;
        }
        if (this._controller && (parameterTypes.length == 0 || this._isAssignableFrom(parameterTypes))) {
            return true;
        }
        _log.error((Object)StringBundler.concat((Object[])new Object[]{"Method ", method, " does not have a valid signature for @", this._annotation.getSimpleName()}));
        return false;
    }

    private BeanPortletMethodType(Class<? extends Annotation> annotation, Function<Annotation, String> characterEncodingFunction, Function<Annotation, String> contentTypeFunction, boolean controller, Function<Annotation, String> includeFunction, Function<Annotation, Integer> ordinalFunction, Class<?>[] parameterTypes, Function<Annotation, PortletMode> portletModeFunction, Function<Annotation, String[]> portletNamesFunction, boolean variant) {
        this._annotation = annotation;
        this._characterEncodingFunction = characterEncodingFunction;
        this._contentTypeFunction = contentTypeFunction;
        this._controller = controller;
        this._includeFunction = includeFunction;
        this._ordinalFunction = ordinalFunction;
        this._parameterTypes = parameterTypes;
        this._portletModeFunction = portletModeFunction;
        this._portletNamesFunction = portletNamesFunction;
        this._variant = variant;
    }

    private boolean _isAssignableFrom(Class<?>[] parameterTypes) {
        if (parameterTypes.length == this._parameterTypes.length) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (this._parameterTypes[i].isAssignableFrom(parameterTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        _log = LogFactoryUtil.getLog(BeanPortletMethodType.class);
    }
}

