/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.registration.portlet;

public class MultipartConfig {
    public static final MultipartConfig UNSUPPORTED = new MultipartConfig(0, null, -1L, -1L, false);
    private final int _fileSizeThreshold;
    private final String _location;
    private final long _maxFileSize;
    private final long _maxRequestSize;
    private final boolean _supported;

    public MultipartConfig(int fileSizeThreshold, String location, long maxFileSize, long maxRequestSize) {
        this(fileSizeThreshold, location, maxFileSize, maxRequestSize, true);
    }

    public int getFileSizeThreshold() {
        return this._fileSizeThreshold;
    }

    public String getLocation() {
        return this._location;
    }

    public long getMaxFileSize() {
        return this._maxFileSize;
    }

    public long getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public boolean isSupported() {
        return this._supported;
    }

    public MultipartConfig merge(MultipartConfig multipartConfig) {
        if (!this._supported && !multipartConfig._supported) {
            return this;
        }
        int fileSizeThreshold = this._fileSizeThreshold;
        if (multipartConfig._fileSizeThreshold > 0) {
            fileSizeThreshold = multipartConfig._fileSizeThreshold;
        }
        String location = this._location;
        if (multipartConfig._location != null) {
            location = multipartConfig._location;
        }
        long maxFileSize = this._maxFileSize;
        if (multipartConfig._maxFileSize > 0L) {
            maxFileSize = multipartConfig._maxFileSize;
        }
        long maxRequestSize = this._maxRequestSize;
        if (multipartConfig._maxRequestSize > 0L) {
            maxRequestSize = multipartConfig._maxRequestSize;
        }
        return new MultipartConfig(fileSizeThreshold, location, maxFileSize, maxRequestSize);
    }

    private MultipartConfig(int fileSizeThreshold, String location, long maxFileSize, long maxRequestSize, boolean supported) {
        this._fileSizeThreshold = fileSizeThreshold;
        this._location = location;
        this._maxFileSize = maxFileSize;
        this._maxRequestSize = maxRequestSize;
        this._supported = supported;
    }
}

