/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.portlet.annotations.PortletRequestScoped;
import javax.portlet.annotations.PortletSerializable;
import javax.portlet.annotations.PortletSessionScoped;
import javax.portlet.annotations.RenderStateScoped;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class PortletScopeResolver
extends AnnotationScopeMetadataResolver {
    private static final Log _log = LogFactoryUtil.getLog(PortletScopeResolver.class);

    public ScopeMetadata resolveScopeMetadata(BeanDefinition beanDefinition) {
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            AnnotationMetadata annotationMetadata = annotatedBeanDefinition.getMetadata();
            Set annotationTypes = annotationMetadata.getAnnotationTypes();
            ScopeMetadata scopeMetadata = null;
            if (annotationTypes.contains(Dependent.class.getName())) {
                scopeMetadata = new ScopeMetadata();
                scopeMetadata.setScopeName("prototype");
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.NO);
            } else if (annotationTypes.contains(PortletRequestScoped.class.getName()) || annotationTypes.contains(RequestScoped.class.getName()) || this._hasScopeAnnotation(annotationMetadata, annotationTypes, "request")) {
                scopeMetadata = new ScopeMetadata();
                scopeMetadata.setScopeName("portletRequest");
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
            } else if (annotationTypes.contains(PortletSessionScoped.class.getName()) || annotationTypes.contains(SessionScoped.class.getName()) || this._hasScopeAnnotation(annotationMetadata, annotationTypes, "session")) {
                List values;
                MultiValueMap annotationAttributes = annotationMetadata.getAllAnnotationAttributes(PortletSessionScoped.class.getName());
                int subscope = 2;
                if (annotationAttributes != null && (values = (List)annotationAttributes.get((Object)"value")) != null && !values.isEmpty()) {
                    subscope = GetterUtil.getInteger(values.get(0), (int)2);
                }
                scopeMetadata = new ScopeMetadata();
                if (subscope == 2) {
                    scopeMetadata.setScopeName("portletSession");
                } else {
                    scopeMetadata.setScopeName("portletAppSession");
                }
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
            } else if (this._hasScopeAnnotation(annotationMetadata, annotationTypes, "globalSession")) {
                scopeMetadata = new ScopeMetadata();
                scopeMetadata.setScopeName("portletAppSession");
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
            } else if (annotationTypes.contains(RenderStateScoped.class.getName())) {
                String[] interfaceNames;
                boolean implementsPortletSerializable = false;
                for (String interfaceName : interfaceNames = annotationMetadata.getInterfaceNames()) {
                    if (!interfaceName.equals(PortletSerializable.class.getName())) continue;
                    implementsPortletSerializable = true;
                    break;
                }
                if (implementsPortletSerializable) {
                    scopeMetadata = new ScopeMetadata();
                    scopeMetadata.setScopeName("portletRenderState");
                    scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
                } else {
                    _log.error((Object)(beanDefinition.getBeanClassName() + " does not implement " + PortletSerializable.class.getName()));
                }
            }
            if (scopeMetadata != null) {
                return scopeMetadata;
            }
        }
        return super.resolveScopeMetadata(beanDefinition);
    }

    private boolean _hasScopeAnnotation(AnnotationMetadata annotationMetadata, Set<String> annotationTypes, String scopeName) {
        if (annotationTypes.contains(Scope.class.getName())) {
            MultiValueMap annotationAttributes = annotationMetadata.getAllAnnotationAttributes(Scope.class.getName());
            String annotatedScopeName = null;
            List values = (List)annotationAttributes.get((Object)"scopeName");
            if (values != null && !values.isEmpty()) {
                annotatedScopeName = (String)values.get(0);
            }
            if (annotatedScopeName == null && (values = (List)annotationAttributes.get((Object)"value")) != null && !values.isEmpty()) {
                annotatedScopeName = (String)values.get(0);
            }
            if (scopeName.equals(annotatedScopeName)) {
                return true;
            }
        }
        return false;
    }
}

