/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal;

import com.liferay.bean.portlet.extension.BeanFilterMethod;
import com.liferay.bean.portlet.extension.BeanFilterMethodFactory;
import com.liferay.bean.portlet.extension.BeanFilterMethodInvoker;
import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodDecorator;
import com.liferay.bean.portlet.extension.BeanPortletMethodFactory;
import com.liferay.bean.portlet.extension.BeanPortletMethodInvoker;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.bean.portlet.extension.ScopedBean;
import com.liferay.bean.portlet.extension.ViewRenderer;
import com.liferay.bean.portlet.registration.util.BeanPortletRegistrarUtil;
import com.liferay.bean.portlet.spring.extension.internal.SpringBeanFilterMethodFactory;
import com.liferay.bean.portlet.spring.extension.internal.SpringBeanPortletMethodFactory;
import com.liferay.bean.portlet.spring.extension.internal.SpringPortletAsyncScopeManager;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringPortletRequestScope;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringPortletSessionScope;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringRedirectScope;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringRenderStateScope;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManager;
import com.liferay.bean.portlet.spring.extension.internal.scope.SpringScopedBeanManagerThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.async.PortletAsyncListenerFactory;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManagerFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.EventPortlet;
import javax.portlet.HeaderPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletAsyncListener;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.DestroyMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.RenderMethod;
import javax.portlet.annotations.ServeResourceMethod;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;

public class SpringBeanPortletExtension {
    private static final Log _log = LogFactoryUtil.getLog(SpringBeanPortletExtension.class);
    private final Set<Class<?>> _annotatedClasses = new HashSet();
    private final ApplicationContext _applicationContext;
    private BeanFactory _configurableBeanFactory;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public SpringBeanPortletExtension(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public void step1RegisterScopes(ConfigurableBeanFactory configurableBeanFactory) {
        configurableBeanFactory.registerScope("portletAppSession", (Scope)new SpringPortletSessionScope(1));
        configurableBeanFactory.registerScope("portletRedirect", (Scope)new SpringRedirectScope());
        configurableBeanFactory.registerScope("portletRenderState", (Scope)new SpringRenderStateScope());
        configurableBeanFactory.registerScope("portletRequest", (Scope)new SpringPortletRequestScope());
        configurableBeanFactory.registerScope("portletSession", (Scope)new SpringPortletSessionScope(2));
        this._configurableBeanFactory = configurableBeanFactory;
    }

    public void step2ProcessAnnotatedType(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (this._isAnnotatedType(clazz)) {
                this._annotatedClasses.add(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Throwable)classNotFoundException);
        }
    }

    public void step3ApplicationScopeInitialized(ServletContext servletContext) {
        BundleContext bundleContext = (BundleContext)servletContext.getAttribute("osgi-bundlecontext");
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"servlet.context.name", (Object)servletContext.getServletContextName()).build();
        this._serviceRegistrations.add(bundleContext.registerService(PortletAsyncScopeManagerFactory.class, SpringPortletAsyncScopeManager::new, (Dictionary)properties));
        this._serviceRegistrations.add(bundleContext.registerService(PortletAsyncListenerFactory.class, (Object)new PortletAsyncListenerFactory(){

            public <T extends PortletAsyncListener> T getPortletAsyncListener(Class<T> clazz) throws PortletException {
                PortletAsyncListener bean = (PortletAsyncListener)SpringBeanPortletExtension.this._applicationContext.getBean(clazz);
                if (bean == null) {
                    throw new PortletException("Unable to create an instance of " + clazz.getName());
                }
                try {
                    return (T)((PortletAsyncListener)clazz.cast(bean));
                }
                catch (Exception exception) {
                    throw new PortletException("Unable to create an instance of " + clazz.getName(), (Throwable)exception);
                }
            }
        }, (Dictionary)properties));
        BeanFilterMethodInvoker beanFilterMethodInvoker = new BeanFilterMethodInvoker(){

            public void invokeWithActiveScopes(BeanFilterMethod beanFilterMethod, Object filterChain, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
                SpringScopedBeanManagerThreadLocal.invokeWithScopedBeanManager(() -> new SpringScopedBeanManager(null, portletRequest, portletResponse), () -> this._invokePortletFilterMethod(beanFilterMethod, portletRequest, portletResponse, filterChain));
            }

            private void _invokePortletFilterMethod(BeanFilterMethod beanFilterMethod, PortletRequest portletRequest, PortletResponse portletResponse, Object filterChain) throws PortletException {
                try {
                    beanFilterMethod.invoke(new Object[]{portletRequest, portletResponse, filterChain});
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PortletException((Throwable)illegalAccessException);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Throwable throwable = reflectiveOperationException.getCause();
                    if (throwable instanceof PortletException) {
                        throw (PortletException)throwable;
                    }
                    throw new PortletException(throwable);
                }
            }
        };
        BeanPortletMethodInvoker beanPortletMethodInvoker = new BeanPortletMethodInvoker(){

            public void invokeWithActiveScopes(List<BeanPortletMethod> beanMethods, PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
                SpringScopedBeanManagerThreadLocal.invokeWithScopedBeanManager(() -> new SpringScopedBeanManager(portletConfig, portletRequest, portletResponse), () -> this._invokePortletBeanMethods(beanMethods, portletRequest, portletResponse, portletConfig));
            }

            private void _invokePortletBeanMethods(List<BeanPortletMethod> beanPortletMethods, PortletRequest portletRequest, PortletResponse portletResponse, PortletConfig portletConfig) throws PortletException {
                for (BeanPortletMethod beanPortletMethod : beanPortletMethods) {
                    SpringBeanPortletExtension.this._invokeBeanPortletMethod(beanPortletMethod, portletConfig, portletRequest, portletResponse);
                }
                if (portletResponse instanceof RenderResponse || portletResponse instanceof ResourceResponse) {
                    ViewRenderer viewRenderer = (ViewRenderer)SpringBeanPortletExtension.this._applicationContext.getBean("viewRenderer", ViewRenderer.class);
                    viewRenderer.render((MimeResponse)portletResponse, portletConfig, portletRequest);
                }
            }
        };
        this._serviceRegistrations.addAll(BeanPortletRegistrarUtil.register((BeanFilterMethodFactory)new SpringBeanFilterMethodFactory(this._configurableBeanFactory), (BeanFilterMethodInvoker)beanFilterMethodInvoker, (BeanPortletMethodFactory)new SpringBeanPortletMethodFactory(this._configurableBeanFactory), (BeanPortletMethodInvoker)beanPortletMethodInvoker, this._annotatedClasses, (ServletContext)servletContext));
    }

    public void step4SessionScopeBeforeDestroyed(HttpSession httpSession) {
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = httpSession.getAttribute(name);
            if (!(value instanceof ScopedBean)) continue;
            ScopedBean scopedBean = (ScopedBean)value;
            scopedBean.destroy();
        }
    }

    public void step5ApplicationScopeBeforeDestroyed(ServletContext servletContext) {
        BeanPortletRegistrarUtil.unregister(this._serviceRegistrations, (ServletContext)servletContext);
        this._serviceRegistrations.clear();
    }

    private void _invokeBeanPortletMethod(BeanPortletMethod beanPortletMethod, PortletConfig portletConfig, PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        try {
            BeanPortletMethodDecorator beanPortletMethodDecorator = (BeanPortletMethodDecorator)this._applicationContext.getBean("beanPortletMethodDecorator", BeanPortletMethodDecorator.class);
            beanPortletMethod = beanPortletMethodDecorator.getBeanPortletMethod(beanPortletMethod, portletConfig, portletRequest, portletResponse);
            String include = null;
            Method method = beanPortletMethod.getMethod();
            BeanPortletMethodType beanPortletMethodType = beanPortletMethod.getBeanPortletMethodType();
            if (beanPortletMethodType == BeanPortletMethodType.ACTION) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                String actionName = null;
                PortletContext portletContext = portletConfig.getPortletContext();
                if (portletContext.getEffectiveMajorVersion() >= 3) {
                    ActionParameters actionParameters = actionRequest.getActionParameters();
                    actionName = actionParameters.getValue("javax.portlet.action");
                } else {
                    actionName = actionRequest.getParameter("javax.portlet.action");
                }
                String beanMethodActionName = beanPortletMethod.getActionName();
                if (Validator.isNull((String)beanMethodActionName) || beanMethodActionName.equals(actionName)) {
                    beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
                }
            } else if (beanPortletMethodType == BeanPortletMethodType.HEADER || beanPortletMethodType == BeanPortletMethodType.RENDER) {
                PortletMode portletMode = portletRequest.getPortletMode();
                PortletMode beanMethodPortletMode = beanPortletMethod.getPortletMode();
                if (beanMethodPortletMode == null || portletMode.equals((Object)beanMethodPortletMode)) {
                    if (method.getParameterCount() == 0) {
                        String markup = (String)beanPortletMethod.invoke(new Object[0]);
                        if (markup != null) {
                            MimeResponse mimeResponse = (MimeResponse)portletResponse;
                            PrintWriter printWriter = mimeResponse.getWriter();
                            printWriter.write(markup);
                        }
                    } else {
                        beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
                    }
                    include = beanPortletMethodType.getInclude(method);
                }
            } else if (beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE) {
                ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
                String resourceID = resourceRequest.getResourceID();
                String beanMethodResourceID = beanPortletMethod.getResourceID();
                if (Validator.isNull((String)beanMethodResourceID) || beanMethodResourceID.equals(resourceID)) {
                    String characterEncoding;
                    ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
                    String contentType = beanPortletMethodType.getContentType(method);
                    if (Validator.isNotNull((String)contentType) && !Objects.equals(contentType, "*/*")) {
                        resourceResponse.setContentType(contentType);
                    }
                    if (Validator.isNotNull((String)(characterEncoding = beanPortletMethodType.getCharacterEncoding(method)))) {
                        resourceResponse.setCharacterEncoding(characterEncoding);
                    }
                    if (method.getParameterCount() == 0) {
                        String markup = (String)beanPortletMethod.invoke(new Object[0]);
                        if (Validator.isNotNull((String)markup)) {
                            PrintWriter printWriter = resourceResponse.getWriter();
                            printWriter.write(markup);
                        }
                    } else {
                        beanPortletMethod.invoke(new Object[]{resourceRequest, resourceResponse});
                    }
                    include = beanPortletMethodType.getInclude(method);
                }
            } else {
                beanPortletMethod.invoke(new Object[]{portletRequest, portletResponse});
            }
            PortletMode beanMethodPortletMode = beanPortletMethod.getPortletMode();
            if (Validator.isNotNull(include) && (beanMethodPortletMode == null || beanMethodPortletMode.equals((Object)portletRequest.getPortletMode()))) {
                PortletContext portletContext = portletConfig.getPortletContext();
                PortletRequestDispatcher requestDispatcher = portletContext.getRequestDispatcher(include);
                if (requestDispatcher == null) {
                    _log.error((Object)("Unable to acquire dispatcher to include " + include));
                } else {
                    requestDispatcher.include(portletRequest, portletResponse);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof PortletException) {
                throw (PortletException)throwable;
            }
            throw new PortletException(throwable);
        }
        catch (PortletException portletException) {
            throw portletException;
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
    }

    private boolean _isAnnotatedType(Class<?> clazz) {
        if (ActionFilter.class.isAssignableFrom(clazz) || EventFilter.class.isAssignableFrom(clazz) || EventPortlet.class.isAssignableFrom(clazz) || HeaderFilter.class.isAssignableFrom(clazz) || HeaderPortlet.class.isAssignableFrom(clazz) || Portlet.class.isAssignableFrom(clazz) || RenderFilter.class.isAssignableFrom(clazz) || ResourceFilter.class.isAssignableFrom(clazz) || ResourceServingPortlet.class.isAssignableFrom(clazz)) {
            return true;
        }
        Method[] methods = null;
        try {
            methods = clazz.getMethods();
        }
        catch (Throwable throwable) {
            String className = clazz.getName();
            if (!className.startsWith("org.springframework")) {
                _log.error((Object)("Unable to discover methods in class " + clazz.getName()), throwable);
            }
            return false;
        }
        for (Method method : methods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                Class<?> annotationClass = annotation.getClass();
                if (!ActionMethod.class.isAssignableFrom(annotationClass) && !DestroyMethod.class.isAssignableFrom(annotationClass) && !EventMethod.class.isAssignableFrom(annotationClass) && !RenderMethod.class.isAssignableFrom(annotationClass) && !ServeResourceMethod.class.isAssignableFrom(annotationClass)) continue;
                return true;
            }
        }
        return false;
    }
}

