/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal;

import com.liferay.bean.portlet.spring.extension.internal.JSR362AutowireCandidateResolver;
import com.liferay.bean.portlet.spring.extension.internal.SpringBeanELResolver;
import com.liferay.bean.portlet.spring.extension.internal.SpringBeanPortletExtension;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Objects;
import javax.el.ELResolver;
import javax.portlet.PortletAsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.context.ServletContextAware;

@Configuration
public class SpringPostProcessor
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor,
ServletContextAware {
    private static final Log _log = LogFactoryUtil.getLog(SpringPostProcessor.class);
    private ApplicationContext _applicationContext;
    private ServletContext _servletContext;
    private SpringBeanPortletExtension _springBeanPortletExtension;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = beanDefinitionRegistry.getBeanDefinitionNames()) {
            if (beanDefinitionName.startsWith("scopedTarget.")) continue;
            BeanDefinition beanDefinition = beanDefinitionRegistry.getBeanDefinition(beanDefinitionName);
            String beanDefinitionScope = beanDefinition.getScope();
            if (Objects.equals(beanDefinitionScope, "globalSession") || Objects.equals(beanDefinitionScope, "portletRequest") || Objects.equals(beanDefinitionScope, "portletAppSession") || Objects.equals(beanDefinitionScope, "portletSession") || Objects.equals(beanDefinitionScope, "renderState") || Objects.equals(beanDefinitionScope, "request") || Objects.equals(beanDefinitionScope, "session")) {
                beanDefinitionRegistry.removeBeanDefinition(beanDefinitionName);
                if (Objects.equals(beanDefinitionScope, "globalSession")) {
                    beanDefinition.setScope("portletAppSession");
                } else if (Objects.equals(beanDefinitionScope, "request")) {
                    beanDefinition.setScope("portletRequest");
                } else if (Objects.equals(beanDefinitionScope, "session")) {
                    beanDefinition.setScope("portletSession");
                }
                BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(beanDefinition, beanDefinitionName);
                ScopeMetadata scopeMetadata = new ScopeMetadata();
                scopeMetadata.setScopeName(beanDefinitionScope);
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
                BeanDefinitionHolder scopedProxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)beanDefinitionRegistry, (boolean)true);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)scopedProxy, (BeanDefinitionRegistry)beanDefinitionRegistry);
                continue;
            }
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName == null) continue;
            try {
                Class<?> beanClass = Class.forName(beanClassName);
                if (!PortletAsyncListener.class.isAssignableFrom(beanClass)) continue;
                beanDefinitionRegistry.removeBeanDefinition(beanDefinitionName);
                beanDefinition.setLazyInit(true);
                BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(beanDefinition, beanDefinitionName);
                ScopeMetadata scopeMetadata = new ScopeMetadata();
                scopeMetadata.setScopeName(beanDefinitionScope);
                scopeMetadata.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
                BeanDefinitionHolder scopedProxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)beanDefinitionRegistry, (boolean)true);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)scopedProxy, (BeanDefinitionRegistry)beanDefinitionRegistry);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _log.error((Throwable)classNotFoundException);
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] beanDefinitionNames;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        defaultListableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new JSR362AutowireCandidateResolver());
        this._springBeanPortletExtension = new SpringBeanPortletExtension(this._applicationContext);
        this._springBeanPortletExtension.step1RegisterScopes((ConfigurableBeanFactory)configurableListableBeanFactory);
        for (String beanDefinitionName : beanDefinitionNames = configurableListableBeanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(beanDefinitionName);
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName == null) continue;
            this._springBeanPortletExtension.step2ProcessAnnotatedType(beanClassName);
        }
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory == null) {
            _log.error((Object)"Unable to register the SpringBeanELResolver with JSP");
        } else {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(this._servletContext);
            jspApplicationContext.addELResolver((ELResolver)new SpringBeanELResolver((BeanFactory)this._applicationContext));
        }
        this._servletContext.setAttribute(SpringBeanPortletExtension.class.getName(), (Object)this._springBeanPortletExtension);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }
}

