/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.spring.extension.internal.mvc;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.bean.portlet.spring.extension.internal.mvc.AfterControllerEventImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeanPortletMethodInterceptor;
import com.liferay.bean.portlet.spring.extension.internal.mvc.BeforeControllerEventImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ControllerRedirectEventImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.ResourceInfoImpl;
import com.liferay.bean.portlet.spring.extension.internal.mvc.UriInfoImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.mvc.View;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.MutableResourceParameters;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.RenderURLWrapper;
import javax.portlet.filter.ResourceURLWrapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ControllerInterceptor
extends BeanPortletMethodInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(ControllerInterceptor.class);
    private final ApplicationEventPublisher _applicationEventPublisher;
    private final Object _eventObject;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;

    public ControllerInterceptor(ApplicationEventPublisher applicationEventPublisher, BeanPortletMethod beanPortletMethod, boolean controller, Object eventObject, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(beanPortletMethod, controller);
        this._applicationEventPublisher = applicationEventPublisher;
        this._eventObject = eventObject;
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
    }

    public Object invoke(Object ... args) throws ReflectiveOperationException {
        RenderParameters renderParameters;
        if (!this.isController()) {
            return super.invoke(args);
        }
        String actionPhaseViewName = null;
        BeanPortletMethodType beanPortletMethodType = this.getBeanPortletMethodType();
        if ((beanPortletMethodType == BeanPortletMethodType.RENDER || beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE) && (renderParameters = this._portletRequest.getRenderParameters()).getValue("redirectedView") != null) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            actionPhaseViewName = (String)portletSession.getAttribute("viewName");
            portletSession.removeAttribute("viewName");
            if (actionPhaseViewName != null) {
                this._portletRequest.setAttribute("viewName", (Object)actionPhaseViewName);
            }
        }
        BeanPortletMethod beanPortletMethod = this.getWrapped();
        this._applicationEventPublisher.publishEvent((ApplicationEvent)new BeforeControllerEventImpl(this._eventObject, new ResourceInfoImpl(beanPortletMethod.getBeanClass(), beanPortletMethod.getMethod()), new UriInfoImpl()));
        Object result = super.invoke(args);
        Object redirectURL = null;
        boolean renderView = true;
        String viewName = null;
        if (Validator.isNull((Object)result)) {
            Method invocationContextMethod = this.getMethod();
            View view = invocationContextMethod.getAnnotation(View.class);
            if (view != null) {
                viewName = view.value();
            }
        } else {
            viewName = result.toString();
        }
        if (Validator.isNotNull((String)viewName) && (beanPortletMethodType == BeanPortletMethodType.ACTION || beanPortletMethodType == BeanPortletMethodType.SERVE_RESOURCE)) {
            PortletSession portletSession = this._portletRequest.getPortletSession(true);
            if (viewName.startsWith("redirect:")) {
                viewName = viewName.substring("redirect:".length());
                redirectURL = beanPortletMethodType == BeanPortletMethodType.ACTION ? new ActionRedirectURL((ActionResponse)this._portletResponse) : new ResourceRedirectURL((ResourceResponse)this._portletResponse);
            }
            portletSession.setAttribute("viewName", (Object)viewName);
            if (beanPortletMethodType == BeanPortletMethodType.ACTION) {
                ActionResponse actionResponse = (ActionResponse)this._portletResponse;
                if (redirectURL == null) {
                    MutableRenderParameters mutableRenderParameters = actionResponse.getRenderParameters();
                    mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
                } else {
                    try {
                        actionResponse.sendRedirect(redirectURL.toString());
                    }
                    catch (IOException ioException) {
                        _log.error((Throwable)ioException);
                    }
                }
            } else if (redirectURL != null) {
                ResourceResponse resourceResponse = (ResourceResponse)this._portletResponse;
                resourceResponse.setStatus(302);
                resourceResponse.addProperty("Location", redirectURL.toString());
                renderView = false;
            }
        }
        if (renderView) {
            if (Validator.isNull((String)viewName)) {
                viewName = actionPhaseViewName;
            }
            if (Validator.isNotNull((String)viewName)) {
                this._portletRequest.setAttribute("viewName", (Object)viewName);
            }
        }
        this._applicationEventPublisher.publishEvent((ApplicationEvent)new AfterControllerEventImpl(this._eventObject, new ResourceInfoImpl(beanPortletMethod.getBeanClass(), beanPortletMethod.getMethod()), new UriInfoImpl()));
        if (redirectURL != null) {
            try {
                URI uri = new URI(redirectURL.toString());
                this._applicationEventPublisher.publishEvent((ApplicationEvent)new ControllerRedirectEventImpl(this._eventObject, uri, new ResourceInfoImpl(beanPortletMethod.getBeanClass(), beanPortletMethod.getMethod()), new UriInfoImpl()));
            }
            catch (URISyntaxException uriSyntaxException) {
                _log.error((Throwable)uriSyntaxException);
            }
        }
        return null;
    }

    private static class ResourceRedirectURL
    extends ResourceURLWrapper {
        private ResourceRedirectURL(ResourceResponse resourceResponse) {
            super(resourceResponse.createResourceURL());
            MutableResourceParameters mutableResourceParameters = this.getResourceParameters();
            mutableResourceParameters.setValue("redirectedView", Boolean.TRUE.toString());
        }
    }

    private static class ActionRedirectURL
    extends RenderURLWrapper {
        private ActionRedirectURL(ActionResponse actionResponse) {
            super(actionResponse.createRedirectURL(MimeResponse.Copy.ALL));
            MutableRenderParameters mutableRenderParameters = this.getRenderParameters();
            mutableRenderParameters.setValue("redirectedView", Boolean.TRUE.toString());
        }
    }
}

