/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.demo.data.creator.internal;

import com.liferay.blogs.demo.data.creator.BlogsEntryDemoDataCreator;
import com.liferay.blogs.demo.data.creator.internal.BaseBlogsEntryDemoDataCreator;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"source=creative-commons"}, service={BlogsEntryDemoDataCreator.class})
public class CreativeCommonsBlogsEntryDemoDataCreatorImpl
extends BaseBlogsEntryDemoDataCreator {
    private final AtomicInteger _atomicInteger = new AtomicInteger(0);
    private final List<Integer> _availableIndexes = new CopyOnWriteArrayList<Integer>();

    public BlogsEntry create(long userId, long groupId) throws IOException, PortalException {
        int index = this._getNextIndex();
        String title = this._getRandomTitle(index);
        String subtitle = this._getRandomSubtitle(index);
        String content = this._getRandomContent(index);
        return this.createBlogsEntry(userId, groupId, title, subtitle, content);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Collections.addAll(this._availableIndexes, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        Collections.shuffle(this._availableIndexes);
    }

    private int _getNextIndex() {
        int index = this._atomicInteger.getAndIncrement();
        if (index == this._availableIndexes.size() - 1) {
            this._atomicInteger.set(0);
        }
        return this._availableIndexes.get(index);
    }

    private String _getRandomContent(int index) throws IOException {
        Class<?> clazz = this.getClass();
        String titlePath = StringBundler.concat((Object[])new Object[]{"com/liferay/blogs/demo/data/creator/internal/dependencies", "/creative/commons/content_", index, ".txt"});
        return StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)titlePath, (boolean)false);
    }

    private String _getRandomSubtitle(int index) throws IOException {
        Class<?> clazz = this.getClass();
        String titlePath = StringBundler.concat((Object[])new Object[]{"com/liferay/blogs/demo/data/creator/internal/dependencies", "/creative/commons/subtitle_", index, ".txt"});
        return StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)titlePath, (boolean)false);
    }

    private String _getRandomTitle(int index) throws IOException {
        Class<?> clazz = this.getClass();
        String titlePath = StringBundler.concat((Object[])new Object[]{"com/liferay/blogs/demo/data/creator/internal/dependencies", "/creative/commons/title_", index, ".txt"});
        return StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)titlePath, (boolean)false);
    }
}

