/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.demo.data.creator.internal;

import com.liferay.blogs.demo.data.creator.BlogsEntryDemoDataCreator;
import com.liferay.blogs.demo.data.creator.internal.BaseBlogsEntryDemoDataCreator;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"source=lorem-ipsum"}, service={BlogsEntryDemoDataCreator.class})
public class LoremIpsumBlogsEntryDemoDataCreatorImpl
extends BaseBlogsEntryDemoDataCreator {
    private static final List<String> _paragraphs = LoremIpsumBlogsEntryDemoDataCreatorImpl._read("paragraphs");
    private static final List<String> _subtitles = LoremIpsumBlogsEntryDemoDataCreatorImpl._read("subtitles");
    private static final List<String> _titles = LoremIpsumBlogsEntryDemoDataCreatorImpl._read("titles");

    public BlogsEntry create(long userId, long groupId) throws IOException, PortalException {
        String title = this._getRandomElement(_titles);
        String subtitle = this._getRandomElement(_subtitles);
        String content = this._getRandomContent();
        return this.createBlogsEntry(userId, groupId, title, subtitle, content);
    }

    private static List<String> _read(String fileName) {
        return Arrays.asList(StringUtil.split((String)StringUtil.read(LoremIpsumBlogsEntryDemoDataCreatorImpl.class, (String)("dependencies/lorem/ipsum/" + fileName + ".txt")), (char)'\n'));
    }

    private String _getRandomContent() {
        int count = RandomUtil.nextInt((int)5) + 3;
        StringBundler sb = new StringBundler(count * 3);
        for (int i = 0; i < count; ++i) {
            sb.append("<p>");
            sb.append(this._getRandomElement(_paragraphs));
            sb.append("</p>");
        }
        return sb.toString();
    }

    private String _getRandomElement(List<String> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }
}

