/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.trash;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.blogs.model.BlogsEntry"}, service={TrashHandler.class})
public class BlogsEntryTrashHandler
extends BaseTrashHandler {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private ModelResourcePermission<BlogsEntry> _blogsEntryModelResourcePermission;
    @Reference
    private Portal _portal;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._blogsEntryLocalService.deleteEntry(classPK);
    }

    public String getClassName() {
        return BlogsEntry.class.getName();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(classPK);
        return PortletURLBuilder.create((PortletURL)this.getRestoreURL(portletRequest, classPK, false)).setParameter("entryId", (Object)entry.getEntryId()).setParameter("urlTitle", entry.getUrlTitle()).buildString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("blogs");
    }

    public boolean isInTrash(long classPK) throws PortalException {
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(classPK);
        return entry.isInTrash();
    }

    public boolean isRestorable(long classPK) throws PortalException {
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(classPK);
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), entry.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !entry.isInTrashContainer();
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._blogsEntryLocalService.restoreEntryFromTrash(userId, classPK);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean containerModel) throws PortalException {
        LiferayPortletURL portletURL = null;
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(classPK);
        String portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        long plid = this._portal.getPlidFromPortletId(entry.getGroupId(), portletId);
        if (plid == 0L) {
            portletId = PortletProviderUtil.getPortletId((String)BlogsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
            portletURL = this._portal.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        } else {
            portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        }
        if (!containerModel) {
            portletURL.setParameter("mvcRenderCommandName", "/blogs/view_entry");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._blogsEntryModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }
}

