/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.upgrade.v1_1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class BlogsEntryUpgradeProcess
extends UpgradeProcess {
    private final FriendlyURLEntryLocalService _friendlyURLEntryLocalService;

    public BlogsEntryUpgradeProcess(FriendlyURLEntryLocalService friendlyURLEntryLocalService) {
        this._friendlyURLEntryLocalService = friendlyURLEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select groupId, entryId, urlTitle from BlogsEntry");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                long groupId = resultSet.getLong(1);
                long classPK = resultSet.getLong(2);
                String urlTitle = resultSet.getString(3);
                long classNameId = PortalUtil.getClassNameId((String)BlogsEntry.class.getName());
                FriendlyURLEntry existingFriendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, classNameId, urlTitle);
                if (existingFriendlyURLEntry != null) {
                    urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, classNameId, classPK, urlTitle);
                }
                this._friendlyURLEntryLocalService.addFriendlyURLEntry(groupId, BlogsEntry.class, classPK, urlTitle, new ServiceContext());
            }
        }
    }
}

