/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.IdentityServiceContextFunction;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpc;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.TextExtractor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Method.class})
public class PingbackMethodImpl
implements Method {
    public static final int ACCESS_DENIED = 49;
    public static final int GENERIC_FAULT = 0;
    public static final int PINGBACK_ALREADY_REGISTERED = 48;
    public static final int SERVER_ERROR = 50;
    public static final int SOURCE_URI_DOES_NOT_EXIST = 16;
    public static final int SOURCE_URI_INVALID = 17;
    public static final int TARGET_URI_DOES_NOT_EXIST = 32;
    public static final int TARGET_URI_INVALID = 33;
    private static final Log _log = LogFactoryUtil.getLog(PingbackMethodImpl.class);
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private Http _http;
    private InetAddressLookup _inetAddressLookup;
    private PingbackProperties _pingbackProperties;
    @Reference
    private Portal _portal;
    private PortletIdLookup _portletIdLookup;
    @Reference
    private PortletLocalService _portletLocalService;
    private String _sourceURI;
    private String _targetURI;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private XmlRpc _xmlRpc;

    public Response execute(long companyId) {
        try {
            Response response = this._addPingback(companyId);
            if (response != null) {
                return response;
            }
            return this._xmlRpc.createSuccess("Pingback accepted");
        }
        catch (DuplicateCommentException duplicateCommentException) {
            return this._xmlRpc.createFault(48, "Pingback is already registered: " + duplicateCommentException.getMessage());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._xmlRpc.createFault(33, "Unable to parse target URI");
        }
    }

    public String getMethodName() {
        return "pingback.ping";
    }

    public String getToken() {
        return "pingback";
    }

    public boolean setArguments(Object[] arguments) {
        try {
            this._sourceURI = (String)arguments[0];
            this._targetURI = (String)arguments[1];
            return true;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    public void setInetAddressLookup(InetAddressLookup inetAddressLookup) {
        this._inetAddressLookup = inetAddressLookup;
    }

    public void setPingbackProperties(PingbackProperties pingbackProperties) {
        this._pingbackProperties = pingbackProperties;
    }

    public void setPortletIdLookup(PortletIdLookup portletIdLookup) {
        this._portletIdLookup = portletIdLookup;
    }

    private Response _addPingback(long companyId) throws Exception {
        if (!this._isPingbackEnabled()) {
            return this._xmlRpc.createFault(-32601, "Pingbacks are disabled");
        }
        BlogsEntry entry = this._getBlogsEntry(companyId);
        if (!entry.isAllowPingbacks() || Validator.isNull((String)entry.getUrlTitle())) {
            return this._xmlRpc.createFault(-32601, "Pingbacks are disabled");
        }
        Response response = this._validateSource();
        if (response != null) {
            return response;
        }
        long userId = this._userLocalService.getDefaultUserId(companyId);
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        String body = StringBundler.concat((String[])new String[]{"[...] ", this._getExcerpt(), " [...] <a href=", this._sourceURI, ">", LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"read-more"), "</a>"});
        ServiceContext serviceContext = this._buildServiceContext(companyId, groupId, entry.getUrlTitle());
        this._commentManager.addComment(userId, groupId, className, classPK, body, (Function)new IdentityServiceContextFunction(serviceContext));
        return null;
    }

    private ServiceContext _buildServiceContext(long companyId, long groupId, String urlTitle) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        String pingbackUserName = LanguageUtil.get((Locale)LocaleUtil.getSiteDefault(), (String)"pingback");
        serviceContext.setAttribute("pingbackUserName", (Serializable)((Object)pingbackUserName));
        String portletId = this._getPortletId(BlogsEntry.class.getName(), PortletProvider.Action.VIEW);
        if (Validator.isNull((String)portletId)) {
            return serviceContext;
        }
        StringBundler sb = new StringBundler(5);
        String layoutFullURL = this._portal.getLayoutFullURL(groupId, portletId);
        sb.append(layoutFullURL);
        sb.append("/-/");
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        sb.append(portlet.getFriendlyURLMapping());
        sb.append("/");
        sb.append(urlTitle);
        serviceContext.setAttribute("redirect", (Serializable)((Object)sb.toString()));
        serviceContext.setLayoutFullURL(layoutFullURL);
        return serviceContext;
    }

    private BlogsEntry _getBlogsEntry(long companyId) throws Exception {
        BlogsEntry entry = null;
        URL url = new URL(this._targetURI);
        String friendlyURL = url.getPath();
        int end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(0, end);
        }
        long plid = this._portal.getPlidFromFriendlyURL(companyId, friendlyURL);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        FriendlyURLMapperThreadLocal.setPRPIdentifiers(new HashMap());
        Portlet portlet = this._portletLocalService.getPortletById(this._getPortletId(BlogsEntry.class.getName(), PortletProvider.Action.VIEW));
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        friendlyURL = url.getPath();
        end = friendlyURL.indexOf("/-/");
        if (end != -1) {
            friendlyURL = friendlyURL.substring(end + "/-/".length() - 1);
        }
        HashMap requestContext = new HashMap();
        friendlyURLMapper.populateParams(friendlyURL, params, requestContext);
        String param = this._getParam(params, "entryId");
        if (Validator.isNotNull((String)param)) {
            long entryId = GetterUtil.getLong((String)param);
            entry = this._blogsEntryLocalService.getEntry(entryId);
        } else {
            long groupId = this._portal.getScopeGroupId(plid);
            String urlTitle = this._getParam(params, "urlTitle");
            entry = this._blogsEntryLocalService.getEntry(groupId, urlTitle);
        }
        return entry;
    }

    private String _getExcerpt() throws Exception {
        String html = this._http.URLtoString(this._sourceURI);
        Source source = new Source((CharSequence)html);
        source.fullSequentialParse();
        List elements = source.getAllElements("a");
        for (Element element : elements) {
            String href = GetterUtil.getString((String)element.getAttributeValue("href"));
            if (!href.equals(this._targetURI)) continue;
            TextExtractor textExtractor = new TextExtractor((Segment)(element = element.getParentElement()));
            String body = textExtractor.toString();
            if (body.length() < this._getLinkbackExcerptLength() && (element = element.getParentElement()) != null) {
                textExtractor = new TextExtractor((Segment)element);
                body = textExtractor.toString();
            }
            return StringUtil.shorten((String)body, (int)this._getLinkbackExcerptLength());
        }
        return "";
    }

    private InetAddress _getInetAddressByName(String domain) throws UnknownHostException {
        if (this._inetAddressLookup != null) {
            return this._inetAddressLookup.getInetAddressByName(domain);
        }
        return InetAddressUtil.getInetAddressByName((String)domain);
    }

    private int _getLinkbackExcerptLength() {
        if (this._pingbackProperties != null) {
            return this._pingbackProperties.getLinkbackExcerptLength();
        }
        return PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH;
    }

    private String _getParam(Map<String, String[]> params, String name) {
        Object[] paramArray = params.get(name);
        if (paramArray == null) {
            String namespace = this._portal.getPortletNamespace(this._getPortletId(BlogsEntry.class.getName(), PortletProvider.Action.VIEW));
            paramArray = params.get(namespace + name);
        }
        if (ArrayUtil.isNotEmpty((Object[])paramArray)) {
            return paramArray[0];
        }
        return null;
    }

    private String _getPortletId(String className, PortletProvider.Action action) {
        if (this._portletIdLookup != null) {
            return this._portletIdLookup.getPortletId(className, action);
        }
        return PortletProviderUtil.getPortletId((String)className, (PortletProvider.Action)action);
    }

    private boolean _isPingbackEnabled() {
        if (this._pingbackProperties != null) {
            return this._pingbackProperties.isPingbackEnabled();
        }
        return PropsValues.BLOGS_PINGBACK_ENABLED;
    }

    private boolean _isSourceURILocalNetwork() {
        try {
            URL url = new URL(this._sourceURI);
            return InetAddressUtil.isLocalInetAddress((InetAddress)this._getInetAddressByName(url.getHost()));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return true;
        }
    }

    private Response _validateSource() throws Exception {
        if (this._isSourceURILocalNetwork()) {
            return this._xmlRpc.createFault(49, "Access Denied");
        }
        Source source = null;
        try {
            String html = this._http.URLtoString(this._sourceURI);
            source = new Source((CharSequence)html);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._xmlRpc.createFault(16, "Error accessing source URI");
        }
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String href = GetterUtil.getString((String)startTag.getAttributeValue("href"));
            if (!href.equals(this._targetURI)) continue;
            return null;
        }
        return this._xmlRpc.createFault(17, "Unable to find target URI in source");
    }

    public static interface PortletIdLookup {
        public String getPortletId(String var1, PortletProvider.Action var2);
    }

    public static interface PingbackProperties {
        public int getLinkbackExcerptLength();

        public boolean isPingbackEnabled();
    }

    public static interface InetAddressLookup {
        public InetAddress getInetAddressByName(String var1);
    }
}

