/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.search.spi.model.index.contributor;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.blogs.model.BlogsEntry"}, service={ModelDocumentContributor.class})
public class BlogsEntryModelDocumentContributor
implements ModelDocumentContributor<BlogsEntry> {
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;

    public void contribute(Document document, BlogsEntry blogsEntry) {
        document.addText("caption", blogsEntry.getCoverImageCaption());
        String content = this._htmlParser.extractText(blogsEntry.getContent());
        document.addText("content", content);
        document.addText("description", blogsEntry.getDescription());
        document.addDate("displayDate", blogsEntry.getDisplayDate());
        document.addDate("modified", blogsEntry.getModifiedDate());
        document.addText("subtitle", blogsEntry.getSubtitle());
        document.addText("title", blogsEntry.getTitle());
        document.addKeywordSortable("urlTitle", blogsEntry.getUrlTitle());
        for (Locale locale : this._language.getAvailableLocales(blogsEntry.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), content);
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), blogsEntry.getTitle());
        }
    }
}

