/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.model.listener;

import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserGroupModelListener
extends BaseModelListener<UserGroup> {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public void onAfterRemoveAssociation(Object userGroupId, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this._unsubscribeUserFromUserGroupGroups((Long)associationClassPK, (Long)userGroupId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        try {
            if (associationClassName.equals(Group.class.getName())) {
                this._unsubscribeUserGroupUsersFromGroup((Long)associationClassPK, (Long)userGroupId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _unsubscribeUserFromUserGroupGroups(long userId, long userGroupId) throws PortalException {
        List groupIds = ListUtil.toList((List)this._groupLocalService.getUserGroups(userId, true), GroupModel::getGroupId);
        for (long groupId : this._userGroupLocalService.getGroupPrimaryKeys(userGroupId)) {
            if (groupIds.contains(groupId)) continue;
            this._blogsEntryLocalService.unsubscribe(userId, groupId);
        }
    }

    private void _unsubscribeUserGroupUsersFromGroup(long groupId, long userGroupId) throws PortalException {
        for (long userId : this._userGroupLocalService.getUserPrimaryKeys(userGroupId)) {
            if (this._groupLocalService.hasUserGroup(userId, groupId)) continue;
            this._blogsEntryLocalService.unsubscribe(userId, groupId);
        }
    }
}

