/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.upgrade.v1_1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class BlogsEntryUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final FriendlyURLEntryLocalService _friendlyURLEntryLocalService;

    public BlogsEntryUpgradeProcess(ClassNameLocalService classNameLocalService, FriendlyURLEntryLocalService friendlyURLEntryLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._friendlyURLEntryLocalService = friendlyURLEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select groupId, entryId, urlTitle from BlogsEntry");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                long groupId = resultSet.getLong(1);
                long classPK = resultSet.getLong(2);
                String urlTitle = resultSet.getString(3);
                long classNameId = PortalUtil.getClassNameId((String)BlogsEntry.class.getName());
                FriendlyURLEntry existingFriendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, classNameId, urlTitle);
                if (existingFriendlyURLEntry != null) {
                    urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, classNameId, classPK, urlTitle, null);
                }
                urlTitle = this._getUniqueUrlTitle(classPK, groupId, urlTitle);
                this._friendlyURLEntryLocalService.addFriendlyURLEntry(groupId, BlogsEntry.class, classPK, urlTitle, new ServiceContext());
            }
        }
    }

    private String _getUniqueUrlTitle(long entryId, long groupId, String title) {
        String urlTitle = null;
        if (title == null) {
            urlTitle = String.valueOf(entryId);
        } else {
            urlTitle = StringUtil.toLowerCase((String)title.trim());
            urlTitle = Validator.isNull((String)urlTitle) || Validator.isNumber((String)urlTitle) || urlTitle.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)urlTitle);
            urlTitle = ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)urlTitle);
        }
        return this._friendlyURLEntryLocalService.getUniqueUrlTitle(groupId, this._classNameLocalService.getClassNameId(BlogsEntry.class), entryId, urlTitle, null);
    }
}

