/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.internal.image;

import com.liferay.image.ImageMagick;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;

public class ImageSelectorProcessor {
    private static final Log _log = LogFactoryUtil.getLog(ImageSelectorProcessor.class);
    private final byte[] _bytes;
    private final ImageMagick _imageMagick;

    public ImageSelectorProcessor(byte[] bytes, ImageMagick imageMagick) {
        this._bytes = bytes;
        this._imageMagick = imageMagick;
    }

    public byte[] cropImage(String cropRegion) throws IOException, PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)cropRegion);
        int height = jsonObject.getInt("height");
        int width = jsonObject.getInt("width");
        int x = jsonObject.getInt("x");
        int y = jsonObject.getInt("y");
        if (x > 0 || y > 0 || width > 0 || height > 0) {
            ImageBag imageBag = ImageToolUtil.read((byte[])this._bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            renderedImage = ImageToolUtil.crop((RenderedImage)renderedImage, (int)height, (int)width, (int)x, (int)y);
            return ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
        }
        return this._bytes;
    }

    public byte[] scaleImage(int width) throws Exception {
        byte[] bytes;
        block3: {
            bytes = null;
            try {
                ImageBag imageBag = ImageToolUtil.read((byte[])this._bytes);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                renderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)width);
                bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)ioException);
            }
        }
        if (bytes == null && this._imageMagick.isEnabled()) {
            bytes = this._imageMagick.scale(this._bytes, "png", width, 0);
        }
        return bytes;
    }
}

