Liferay.Loader.define("blogs-web$dnd-core@11.1.3/dist/esm/DragDropManagerImpl", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    import { createStore } from 'redux';
    import { reduce } from './reducers';
    import { createDragDropActions } from './actions/dragDrop';
    import { DragDropMonitorImpl } from './DragDropMonitorImpl';
    import { HandlerRegistryImpl } from './HandlerRegistryImpl';

    function makeStoreInstance(debugMode) {
      // TODO: if we ever make a react-native version of this,
      // we'll need to consider how to pull off dev-tooling
      var reduxDevTools = typeof window !== 'undefined' && window.__REDUX_DEVTOOLS_EXTENSION__;
      return createStore(reduce, debugMode && reduxDevTools && reduxDevTools({
        name: 'dnd-core',
        instanceId: 'dnd-core'
      }));
    }

    export var DragDropManagerImpl = /*#__PURE__*/function () {
      function DragDropManagerImpl() {
        var _this = this;

        var debugMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

        _classCallCheck(this, DragDropManagerImpl);

        this.isSetUp = false;

        this.handleRefCountChange = function () {
          var shouldSetUp = _this.store.getState().refCount > 0;

          if (_this.backend) {
            if (shouldSetUp && !_this.isSetUp) {
              _this.backend.setup();

              _this.isSetUp = true;
            } else if (!shouldSetUp && _this.isSetUp) {
              _this.backend.teardown();

              _this.isSetUp = false;
            }
          }
        };

        var store = makeStoreInstance(debugMode);
        this.store = store;
        this.monitor = new DragDropMonitorImpl(store, new HandlerRegistryImpl(store));
        store.subscribe(this.handleRefCountChange);
      }

      _createClass(DragDropManagerImpl, [{
        key: "receiveBackend",
        value: function receiveBackend(backend) {
          this.backend = backend;
        }
      }, {
        key: "getMonitor",
        value: function getMonitor() {
          return this.monitor;
        }
      }, {
        key: "getBackend",
        value: function getBackend() {
          return this.backend;
        }
      }, {
        key: "getRegistry",
        value: function getRegistry() {
          return this.monitor.registry;
        }
      }, {
        key: "getActions",
        value: function getActions() {
          /* eslint-disable-next-line @typescript-eslint/no-this-alias */
          var manager = this;
          var dispatch = this.store.dispatch;

          function bindActionCreator(actionCreator) {
            return function () {
              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
              }

              var action = actionCreator.apply(manager, args);

              if (typeof action !== 'undefined') {
                dispatch(action);
              }
            };
          }

          var actions = createDragDropActions(this);
          return Object.keys(actions).reduce(function (boundActions, key) {
            var action = actions[key];
            boundActions[key] = bindActionCreator(action);
            return boundActions;
          }, {});
        }
      }, {
        key: "dispatch",
        value: function dispatch(action) {
          this.store.dispatch(action);
        }
      }]);

      return DragDropManagerImpl;
    }();
  }
});
//# sourceMappingURL=DragDropManagerImpl.js.map