/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.bookmarks.uad.display;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.uad.constants.BookmarksEntryUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the bookmarks entry UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in {@link
 * BookmarksEntryUADDisplay}.
 * </p>
 *
 * @author William Newbury
 */
public abstract class BaseBookmarksEntryUADDisplay
	extends BaseModelUADDisplay<BookmarksEntry> {

	@Override
	public BookmarksEntry get(Serializable primaryKey) throws PortalException {
		return bookmarksEntryLocalService.getBookmarksEntry(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"name", "description", "url"};
	}

	@Override
	public Class<BookmarksEntry> getTypeClass() {
		return BookmarksEntry.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return bookmarksEntryLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return bookmarksEntryLocalService.dynamicQuery();
	}

	@Override
	protected List<BookmarksEntry> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return bookmarksEntryLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return BookmarksEntryUADConstants.USER_ID_FIELD_NAMES_BOOKMARKS_ENTRY;
	}

	@Reference
	protected BookmarksEntryLocalService bookmarksEntryLocalService;

}