/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.uad.anonymizer;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.uad.constants.BookmarksEntryUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseBookmarksEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<BookmarksEntry> {
    @Reference
    protected BookmarksEntryLocalService bookmarksEntryLocalService;

    public void autoAnonymize(BookmarksEntry bookmarksEntry, long userId, User anonymousUser) throws PortalException {
        if (bookmarksEntry.getStatusByUserId() == userId) {
            bookmarksEntry.setStatusByUserId(anonymousUser.getUserId());
            bookmarksEntry.setStatusByUserName(anonymousUser.getScreenName());
        }
        if (bookmarksEntry.getUserId() == userId) {
            bookmarksEntry.setUserId(anonymousUser.getUserId());
            bookmarksEntry.setUserName(anonymousUser.getFullName());
        }
        this.bookmarksEntryLocalService.updateBookmarksEntry(bookmarksEntry);
    }

    public void delete(BookmarksEntry bookmarksEntry) throws PortalException {
        this.bookmarksEntryLocalService.deleteEntry(bookmarksEntry);
    }

    public Class<BookmarksEntry> getTypeClass() {
        return BookmarksEntry.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.bookmarksEntryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return BookmarksEntryUADConstants.USER_ID_FIELD_NAMES_BOOKMARKS_ENTRY;
    }
}

