/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.bookmarks.uad.constants.BookmarksUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseBookmarksFolderUADAnonymizer
extends DynamicQueryUADAnonymizer<BookmarksFolder> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected BookmarksFolderLocalService bookmarksFolderLocalService;

    public void autoAnonymize(BookmarksFolder bookmarksFolder, long userId, User anonymousUser) throws PortalException {
        if (bookmarksFolder.getUserId() == userId) {
            bookmarksFolder.setUserId(anonymousUser.getUserId());
            bookmarksFolder.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(bookmarksFolder, anonymousUser);
        }
        if (bookmarksFolder.getStatusByUserId() == userId) {
            bookmarksFolder.setStatusByUserId(anonymousUser.getUserId());
            bookmarksFolder.setStatusByUserName(anonymousUser.getFullName());
        }
        this.bookmarksFolderLocalService.updateBookmarksFolder(bookmarksFolder);
    }

    public void delete(BookmarksFolder bookmarksFolder) throws PortalException {
        this.bookmarksFolderLocalService.deleteFolder(bookmarksFolder);
    }

    public Class<BookmarksFolder> getTypeClass() {
        return BookmarksFolder.class;
    }

    protected void autoAnonymizeAssetEntry(BookmarksFolder bookmarksFolder, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(bookmarksFolder);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.bookmarksFolderLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return BookmarksUADConstants.USER_ID_FIELD_NAMES_BOOKMARKS_FOLDER;
    }

    protected AssetEntry fetchAssetEntry(BookmarksFolder bookmarksFolder) {
        return this.assetEntryLocalService.fetchEntry(BookmarksFolder.class.getName(), bookmarksFolder.getFolderId());
    }
}

