/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.rest.client.pagination;

public class Pagination {
    private final int _page;
    private final int _pageSize;

    public static Pagination of(int page, int pageSize) {
        return new Pagination(page, pageSize);
    }

    public int getEndPosition() {
        if (this._page < 0 || this._pageSize < 0) {
            return -1;
        }
        return this._page * this._pageSize;
    }

    public int getPage() {
        return this._page;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public int getStartPosition() {
        if (this._page < 0 || this._pageSize < 0) {
            return -1;
        }
        return (this._page - 1) * this._pageSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\"page\": ");
        sb.append(this._page);
        sb.append(", \"pageSize\": ");
        sb.append(this._pageSize);
        sb.append("}");
        return sb.toString();
    }

    private Pagination(int page, int pageSize) {
        this._page = page;
        this._pageSize = pageSize;
    }
}

