/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.rest.internal.resource.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.bulk.rest.dto.v1_0.DocumentBulkSelection;
import com.liferay.bulk.rest.dto.v1_0.TaxonomyCategory;
import com.liferay.bulk.rest.dto.v1_0.TaxonomyVocabulary;
import com.liferay.bulk.rest.internal.resource.v1_0.BaseTaxonomyVocabularyResourceImpl;
import com.liferay.bulk.rest.internal.selection.v1_0.DocumentBulkSelectionFactory;
import com.liferay.bulk.rest.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/taxonomy-vocabulary.properties"}, scope=ServiceScope.PROTOTYPE, service={TaxonomyVocabularyResource.class})
public class TaxonomyVocabularyResourceImpl
extends BaseTaxonomyVocabularyResourceImpl {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DocumentBulkSelectionFactory _documentBulkSelectionFactory;
    @Reference
    private Portal _portal;

    @Override
    public Page<TaxonomyVocabulary> postSiteTaxonomyVocabulariesCommonPage(Long siteId, DocumentBulkSelection documentBulkSelection) throws Exception {
        Map<AssetVocabulary, List<AssetCategory>> assetCategoriesMap = this._getAssetCategoriesMap(siteId, documentBulkSelection);
        return Page.of(this.transform(assetCategoriesMap.entrySet(), entry -> this._toTaxonomyVocabulary((List)entry.getValue(), (AssetVocabulary)entry.getKey())));
    }

    private Map<AssetVocabulary, List<AssetCategory>> _getAssetCategoriesMap(Long siteId, DocumentBulkSelection documentBulkSelection) throws Exception {
        Stream<AssetVocabulary> assetVocabulariesStream = this._getAssetVocabulariesStream(siteId);
        Stream<AssetCategory> assetCategoriesStream = this._getAssetCategoriesStream(documentBulkSelection, PermissionCheckerFactoryUtil.create((User)this.contextUser));
        Map<Long, List<AssetCategory>> assetCategoriesMap = assetCategoriesStream.collect(Collectors.groupingBy(AssetCategoryModel::getVocabularyId));
        return assetVocabulariesStream.collect(Collectors.toMap(Function.identity(), assetVocabulary -> assetCategoriesMap.computeIfAbsent(assetVocabulary.getVocabularyId(), key -> new ArrayList())));
    }

    private Stream<AssetCategory> _getAssetCategoriesStream(DocumentBulkSelection documentBulkSelection, PermissionChecker permissionChecker) throws Exception {
        HashSet assetCategories = new HashSet();
        AtomicBoolean flag = new AtomicBoolean(true);
        BulkSelection<?> bulkSelection = this._documentBulkSelectionFactory.create(documentBulkSelection);
        BulkSelection assetEntryBulkSelection = bulkSelection.toAssetEntryBulkSelection();
        assetEntryBulkSelection.forEach(assetEntry -> {
            if (BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
                List assetEntryAssetCategories = this._assetCategoryLocalService.getCategories(assetEntry.getClassName(), assetEntry.getClassPK());
                if (flag.get()) {
                    flag.set(false);
                    assetCategories.addAll(assetEntryAssetCategories);
                } else {
                    assetCategories.retainAll(assetEntryAssetCategories);
                }
            }
        });
        return assetCategories.stream();
    }

    private Stream<AssetVocabulary> _getAssetVocabulariesStream(Long siteId) throws Exception {
        List assetVocabularies = this._assetVocabularyLocalService.getGroupVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(siteId.longValue()));
        Stream stream = assetVocabularies.stream();
        List filteredAssetVocabularies = stream.filter(assetVocabulary -> assetVocabulary.isAssociatedToClassNameId(this._getClassNameId())).filter(assetVocabulary -> {
            int count = this._assetCategoryLocalService.getVocabularyCategoriesCount(assetVocabulary.getVocabularyId());
            return count > 0;
        }).collect(Collectors.toList());
        return filteredAssetVocabularies.stream();
    }

    private long _getClassNameId() {
        return this._classNameLocalService.getClassNameId(DLFileEntry.class.getName());
    }

    private TaxonomyVocabulary _toTaxonomyVocabulary(final List<AssetCategory> assetCategories, final AssetVocabulary assetVocabulary) {
        return new TaxonomyVocabulary(){
            {
                this.multiValued = assetVocabulary.isMultiValued();
                this.name = assetVocabulary.getName();
                this.required = assetVocabulary.isRequired(TaxonomyVocabularyResourceImpl.this._getClassNameId(), -1L);
                this.taxonomyCategories = (TaxonomyCategory[])TaxonomyVocabularyResourceImpl.this.transformToArray(assetCategories, assetCategory -> new TaxonomyCategory((AssetCategory)assetCategory){
                    final /* synthetic */ AssetCategory val$assetCategory;
                    {
                        this.val$assetCategory = assetCategory;
                        this.taxonomyCategoryId = this.val$assetCategory.getCategoryId();
                        this.taxonomyCategoryName = this.val$assetCategory.getName();
                    }
                }, TaxonomyCategory.class);
                this.taxonomyVocabularyId = assetVocabulary.getVocabularyId();
            }
        };
    }
}

