/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.recurrence;

import com.liferay.calendar.recurrence.Frequency;
import com.liferay.calendar.recurrence.PositionalWeekday;
import com.liferay.calendar.recurrence.Weekday;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public class Recurrence {
    private int _count;
    private List<Calendar> _exceptionJCalendars = new ArrayList<Calendar>();
    private Frequency _frequency;
    private int _interval;
    private List<Integer> _months = Collections.emptyList();
    private List<PositionalWeekday> _positionalWeekdays = Collections.emptyList();
    private TimeZone _timeZone;
    private Calendar _untilJCalendar;

    public void addExceptionJCalendar(Calendar jCalendar) {
        this._exceptionJCalendars.add(jCalendar);
    }

    public Recurrence clone() {
        Recurrence recurrence = new Recurrence();
        recurrence.setCount(this._count);
        recurrence.setExceptionJCalendars(new ArrayList<Calendar>(this._exceptionJCalendars));
        recurrence.setFrequency(this._frequency);
        recurrence.setInterval(this._interval);
        recurrence.setMonths(new ArrayList<Integer>(this._months));
        recurrence.setPositionalWeekdays(new ArrayList<PositionalWeekday>(this._positionalWeekdays));
        recurrence.setTimeZone(this._timeZone);
        Calendar untilJCalendar = null;
        if (this._untilJCalendar != null) {
            untilJCalendar = (Calendar)this._untilJCalendar.clone();
        }
        recurrence.setUntilJCalendar(untilJCalendar);
        return recurrence;
    }

    public int getCount() {
        return this._count;
    }

    public List<Calendar> getExceptionJCalendars() {
        return this._exceptionJCalendars;
    }

    public Frequency getFrequency() {
        return this._frequency;
    }

    public int getInterval() {
        return this._interval;
    }

    public List<Integer> getMonths() {
        return this._months;
    }

    public PositionalWeekday getPositionalWeekday() {
        if (this._positionalWeekdays.isEmpty()) {
            return null;
        }
        return this._positionalWeekdays.get(0);
    }

    public List<PositionalWeekday> getPositionalWeekdays() {
        return this._positionalWeekdays;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public Calendar getUntilJCalendar() {
        return this._untilJCalendar;
    }

    public List<Weekday> getWeekdays() {
        ArrayList<Weekday> weekdays = new ArrayList<Weekday>();
        for (PositionalWeekday positionalWeekday : this._positionalWeekdays) {
            weekdays.add(positionalWeekday.getWeekday());
        }
        return weekdays;
    }

    public void removeExceptionJCalendar(Calendar jCalendar) {
        this._exceptionJCalendars.remove(jCalendar);
    }

    public void setCount(int count) {
        this._count = count;
    }

    public void setExceptionJCalendars(List<Calendar> exceptionJCalendars) {
        this._exceptionJCalendars = exceptionJCalendars;
    }

    public void setFrequency(Frequency frequency) {
        this._frequency = frequency;
    }

    public void setInterval(int interval) {
        this._interval = interval;
    }

    public void setMonths(List<Integer> months) {
        this._months = months;
    }

    public void setPositionalWeekdays(List<PositionalWeekday> positionalWeekdays) {
        this._positionalWeekdays = positionalWeekdays;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public void setUntilJCalendar(Calendar untilJCalendar) {
        this._untilJCalendar = untilJCalendar;
    }
}

